/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Namespace
    Foam::constant::electromagnetic

Description
    Electromagnetic constants

\*---------------------------------------------------------------------------*/

#ifndef gpuelectromagneticConstants_H
#define gpuelectromagneticConstants_H

#include "scalar.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace constant
{
namespace electromagnetic
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

    //- Magnetic constant/permeability of free space: default SI units: [H/m]
    __constant__  scalar gmu0;

    //- Electric constant: default SI units: [F/m]
    __constant__  scalar gepsilon0;

    //- Characteristic impedance of a vacuum: default SI units: [ohm]
    __constant__  scalar gZ0;

    //- Coulomb constant: default SI units: [N.m2/C2]
    __constant__  scalar gkappa;

    //- Conductance quantum: default SI units: [S]
    __constant__  scalar gG0;

    //- Josephson constant: default SI units: [Hz/V]
    __constant__  scalar gKJ;

    //- Magnetic flux quantum: default SI units: [Wb]
    __constant__  scalar gphi0;

    //- Von Klitzing constant: default SI units: [ohm]
    __constant__  scalar gRK;


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace electromagnetic
} // End namespace constant
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
