/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015, 2019 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "kqRWallFunctionFvPatchgpuField.H"
#include "addToRunTimeSelectionTable.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

template<class Type>
Foam::kqRWallFunctionFvPatchgpuField<Type>::kqRWallFunctionFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF
)
:
    zeroGradientFvPatchgpuField<Type>(p, iF)
{}


template<class Type>
Foam::kqRWallFunctionFvPatchgpuField<Type>::kqRWallFunctionFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    zeroGradientFvPatchgpuField<Type>(p, iF, dict)
{}


template<class Type>
Foam::kqRWallFunctionFvPatchgpuField<Type>::kqRWallFunctionFvPatchgpuField
(
    const kqRWallFunctionFvPatchgpuField& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    zeroGradientFvPatchgpuField<Type>(ptf, p, iF, mapper)
{}


template<class Type>
Foam::kqRWallFunctionFvPatchgpuField<Type>::kqRWallFunctionFvPatchgpuField
(
    const kqRWallFunctionFvPatchgpuField& tkqrwfpf
)
:
    zeroGradientFvPatchgpuField<Type>(tkqrwfpf)
{}


template<class Type>
Foam::kqRWallFunctionFvPatchgpuField<Type>::kqRWallFunctionFvPatchgpuField
(
    const kqRWallFunctionFvPatchgpuField& tkqrwfpf,
    const DimensionedgpuField<Type, gpuvolMesh>& iF
)
:
    zeroGradientFvPatchgpuField<Type>(tkqrwfpf, iF)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
void Foam::kqRWallFunctionFvPatchgpuField<Type>::evaluate
(
    const Pstream::commsTypes commsType
)
{
    zeroGradientFvPatchgpuField<Type>::evaluate(commsType);
}


template<class Type>
void Foam::kqRWallFunctionFvPatchgpuField<Type>::write(Ostream& os) const
{
    zeroGradientFvPatchgpuField<Type>::write(os);
    this->writeEntry("value", os);
}


// ************************************************************************* //
