/*******************************************************************************************
 * This file contains the declarations of GPU kernels related to thermophysical properties.
 ******************************************************************************************/

#ifndef _THERMOFLUID_KERNEL_H
#define _THERMOFLUID_KERNEL_H

#include "common.h"

void update_c_from_T_P_h(REAL *c, REAL *T, REAL *P);

void update_T_P_from_c_h(REAL *c, REAL *T, REAL *P);

void formYupdateX_h(int size, REAL *sp_W, REAL *W_mix, REAL *X, REAL *Y);

void formXupdateY_h(int size, REAL *sp_W, REAL *W_mix, REAL *X, REAL *Y);

void compute_ha_cp_h(REAL *T, REAL *T_range, REAL *sp_nasa, REAL *sp_ha_mole, REAL *sp_cp_mole);

void compute_ha_mass_h(REAL *sp_ha_mole, REAL *sp_W, REAL *Y, REAL *ha_mass);

void compute_hc_mass_h(REAL *sp_nasa, REAL *sp_W, REAL *sp_hc_mass);

void get_rho_h(REAL *P, REAL *T, REAL *W_mix, REAL *rho);

void get_c_h(REAL *rho, REAL *Y, REAL *sp_W, REAL *c);

void get_psi_h(REAL *rho, REAL *psi);

void h_constraint_h(REAL *X, REAL *c);

void c_constraint_h(REAL *c);

void enthalpy_to_temperature_h(REAL *c, REAL *T_range, REAL *sp_nasa, REAL *Y, REAL *sp_W, REAL *h_target, REAL *T);

#endif //_THERMOFLUID_KERNEL_H