/*******************************************************************************************
 * This file contains the declarations of GPU kernels related to seluex compute.
 ******************************************************************************************/


#ifndef _SEULEX_KERNEL_H
#define _SEULEX_KERNEL_H

void compute_scale0_h(REAL *y, REAL *scale);
void compute_A_h(REAL *A_d, REAL *J_d, REAL *dt, int k);
void initP_h(REAL *ptr);
void copy_AtoU_h(REAL *src, REAL *ptr);
void PLU_decomposition_h(REAL *A, REAL *tmp_ptr_d);
void solve_linear_system_h(REAL *tmp_ptr_d, REAL *b);
void init_y_temp_h(REAL *dy, REAL *c);
void update_y_temp_h(REAL *dy, REAL *dcdt);
void compute_dy1_h(REAL *dcdt, REAL *scale, REAL *denom);
void update_dcdt_h(REAL *dydx, REAL *dt, int k, REAL *dcdt);
void update_c_h(REAL *c, REAL *y_tmp, REAL *dcdt);
void compute_table_h(int k, REAL *y_seq, REAL *table);
void extrapolate_h(int k, REAL *table, REAL *y);
void err_compute_h(REAL *y, REAL *table, REAL *scale, REAL *flag_reject);
void update_dx_h(REAL num, REAL *dt_sum, REAL dt_end, REAL *dx, REAL *dx_new, REAL *flag);
void update_dx_modify_h(REAL num, REAL *dt_sum, REAL dt_end, REAL *dx, REAL *dx_new, REAL *flag, REAL *successed);
void update_dt_sum_h(REAL *dx, REAL *dt_new, REAL dt_end, REAL *dx_new);
void compute_flag_h(REAL *denom, REAL *dy, REAL *scale, REAL *flag_reject);
void judge_flag_h(REAL *flag_reject, REAL result);
void dt_sum_dt_end_h(REAL *dt_sum, REAL dt_end, REAL *c_old, REAL *c_new);
void flag_end_h(REAL *dt_sum, REAL dt_end, REAL *flag_d);

#endif //_SEULEX_KERNEL_H