/*******************************************************************************************
 * This file contains all the parameters and function declarations related to seulex,
 * which are implemented in seulex.cpp.
 ******************************************************************************************/


#ifndef _SEULEX_H
#define _SEULEX_H

#include "common.h"

class seulex_d
{
public:

    size_t n_seq_h[k_max+1] = {2, 3, 4, 6, 8, 12, 16, 24, 32, 48, 64, 96, 128};
    REAL   coeff_h[(k_max+1)*(k_max+1)];

    REAL *J_h  = nullptr;
    REAL *J_d  = nullptr;
    REAL *A_h  = nullptr;
    REAL *A_d  = nullptr;
    REAL *y_temp_h = nullptr;
    REAL *y_temp_d = nullptr;  //[size][n_var]
    REAL *y_d      = nullptr;  //[size][n_var]
    REAL *y_seq_d  = nullptr;  //[size][n_var]
    REAL *denom_d  = nullptr;  //[size]
    REAL *dydx_d   = nullptr;  //[size][n_var]
    REAL *c_old_d  = nullptr;  //[size][n_var]

    REAL *tmp_ptr_h = nullptr;
    REAL *tmp_ptr_d = nullptr;

    REAL *dt_c_d = nullptr;        //[size]
    REAL *dt_c_new_d = nullptr;    //[size]

    REAL *dt_min = nullptr;
    REAL *dt_min_d = nullptr;
    REAL *dt_sum_min = nullptr;
    REAL *dt_sum_min_d = nullptr;

    REAL *flag_d = nullptr;
    
    REAL dt_c     = 1e-10;
    REAL dt_c_new = 1e-10;
    REAL dt_c_sum = 0.;

    REAL *scale_d = nullptr;   //[size][n_var]
    REAL *table_d = nullptr;   //[size][k_max][n_var]

    REAL *flag_reject_d = nullptr; //[size]
    REAL *success_d = nullptr; //[size]
    REAL *unsuccess_d = nullptr; //[size]

    REAL *flag_end = nullptr;
    REAL *flag_end_d = nullptr;


    seulex_d(); 
    ~seulex_d(); 

    void seulex_init();

    void seulex_d_set_J(REAL *J_ref);

    void seulex_d_set_dy(REAL *dy_ref);

    void seulex_d_get_J();

    void seulex_d_get_A();

    void seulex_d_get_dy();

    void get_y_seq(REAL *y_seq_h);

    void compute_A();

    void PLU_decomposition();

    void seulex_d_get_PLU();

    void compute_scale();

    void solve_linear_system();

    REAL seul(int k);

    void seulex_solver(REAL t_end, REAL *flag);
};


/** Global variables for seulex_d class types.
 */
extern seulex_d *seulex_d_ptr;

#endif //_SEULEX_H