/*******************************************************************************************
 * This file contains the declarations of GPU kernels related to jacobian compute.
 ******************************************************************************************/

#ifndef _JACOBIAN_KERNEL_H
#define _JACOBIAN_KERNEL_H

#include "common.h"


void computeJ0(REAL *kf, REAL *kr, REAL *vf, REAL *vr, REAL *react_c, REAL *c, REAL *J);

void computeJ1(REAL *react_type, REAL *fall_type, REAL *q, REAL *T, REAL *tb_coeffs, REAL *fall_coeffs, REAL *c, REAL *J, REAL *v_net, REAL *kf_low, REAL *kf);

void compute_dBdT_h(REAL *T, REAL *T_range, REAL *sp_nasa, REAL *dBdT);

void compute_J2_h(REAL *dBdT, REAL *q, REAL *v_net, REAL *kf_low, REAL *kf, REAL *kr, REAL *T, REAL *abe,
 REAL *react_type, REAL *tb_coeffs, REAL *c, REAL *fall_type, REAL *fall_coeffs, REAL *vr, REAL *vf, REAL *J);

void compute_J3_h(REAL *T, REAL *T_range, REAL *sp_nasa, REAL *c, REAL *sp_cp_mole, REAL *sp_ha_mole, 
            REAL *dcdt, REAL *J);
            
#endif //_JACOBIAN_KERNEL_H