/*******************************************************************************************
 * This file contains all the parameters and function declarations related to jacobian,
 * which are implemented in jacobian.cpp.
 ******************************************************************************************/

#ifndef _JACOBIAN_H
#define _JACOBIAN_H

#include "common.h"

class jacobian_d
{
public:
    reactions_ptr reactions_ptr_h;
    reactions_ptr reactions_ptr_d;

    REAL *J_h = nullptr;       //[grid_num][sp_num*sp_num]
    REAL *J_d = nullptr;       //[grid_num][sp_num*sp_num]
    REAL *tmp_ptr  = nullptr;   //temporary memory [grid_num][sp_num]

    jacobian_d(); 
    ~jacobian_d(); 

    void jacobian_init();

    void updateJ0();

    void jacobian_d_get();

    void updateJ1(REAL *y0);

    void updateJ2(REAL *y0);

    void updateJ3(REAL *y0);

    void jacobian(REAL *y0);

};

#endif //_JACOBIAN_H