/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     | avalanche module
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2017 Matthias Rauter
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::depositionModels::Stoppingprofile

Description
    A deposition model derived from a decelerating velocity profile.
    Rauter and Koehler. "Constraints on entrainment and deposition models in
    avalanche simulations from high-resolution radar data", Geosciences, 2019

SourceFiles
    Stoppingprofile.C

Author
    Matthias Rauter matthias@rauter.it

\*---------------------------------------------------------------------------*/

#ifndef Stoppingprofile_H
#define Stoppingprofile_H

#include "depositionModel.H"
#include "dimensionedScalar.H"
#include "volFields.H"
#include "IOdictionary.H"
#include "typeInfo.H"
#include "runTimeSelectionTables.H"
#include "dimensionedScalar.H"
#include "tmp.H"
#include "autoPtr.H"
#include "faMatrices.H"


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace depositionModels
{

/*---------------------------------------------------------------------------*\
                           Class Stoppingprofile Declaration
\*---------------------------------------------------------------------------*/

class Stoppingprofile
:
    public depositionModel
{
    // Private data

        //- Deposition velocity parameter u_d
        dimensionedScalar ud_;

        //- Form-factor for deposition curve
        dimensionedScalar ad_;

        //- Reference to the gravitation fields
        const areaVectorField& gs_;
        const areaScalarField& gn_;

public:

    //- Runtime type information
    TypeName("Stoppingprofile");


    // Constructors

        //- Construct from components
        Stoppingprofile
        (
            const dictionary& frictionProperties,
            const areaVectorField& Us,
            const areaScalarField& h,
            const areaScalarField& hentrain,
            const areaScalarField& pb,
            const areaVectorField& tau
        );


    //- Destructor
    virtual ~Stoppingprofile() = default;


    // Member Functions

        //- Return Sink by deposition
        virtual const areaScalarField& Sd() const;

        //- Read depositionProperties dictionary
        virtual bool read(const dictionary& depositionProperties);
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace frictionModels
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
