namespace Foam
{

//- Interpolate field vf according to direction dir
template<class Type>
tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> interpolate
(
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf,
    const surfaceScalargpuField& dir,
    const word& reconFieldName = word::null
)
{
    tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> tsf
    (
        fvc::interpolate
        (
            vf,
            dir,
            "reconstruct("
          + (reconFieldName != word::null ? reconFieldName : vf.name())
          + ')'
        )
    );

    GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>& sf = tsf.ref();

    sf.rename(vf.name() + '_' + dir.name());

    return tsf;
}

}
