if (nAlphaSubCycles > 1)
{
    dimensionedScalar totalDeltaT = runTime.deltaT();
    surfaceScalargpuField rhoPhiSum
    (
        IOobject
        (
            "rhoPhiSum",
            runTime.timeName(),
            mesh
        ),
        devicemesh,
        dimensionedScalar(rhoPhi.dimensions(), Zero)
    );

    tmp<volScalargpuField> trSubDeltaT;

    if (LTS)
    {
        trSubDeltaT =
            fv::gpulocalEulerDdt::localRSubDeltaT(devicemesh, nAlphaSubCycles);
    }

    for
    (
        subCycle<volScalargpuField> alphaSubCycle(alpha1, nAlphaSubCycles);
        !(++alphaSubCycle).end();
    )
    {
        #include "alphaEqn.H"
        rhoPhiSum += (runTime.deltaT()/totalDeltaT)*rhoPhi;
    }

    rhoPhi = rhoPhiSum;
}
else
{
    #include "alphaEqn.H"
}

rho == alpha1*rho1 + alpha2*rho2;
