/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

InClass
    Foam::volgpuFields

Description

SourceFiles
    volgpuFields.C

\*---------------------------------------------------------------------------*/

#ifndef volgpuFields_H
#define volgpuFields_H

#include "GeometricgpuFields.H"
#include "gpuvolMesh.H"
#include "gpufvMesh.H"
#include "fvPatchgpuField.H"
#include "volgpuFieldsFwd.H"
#include "calculatedFvPatchgpuFields.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// Specializations

template<>
tmp<GeometricgpuField<scalar, fvPatchgpuField, gpuvolMesh>>
GeometricgpuField<scalar, fvPatchgpuField, gpuvolMesh>::component
(
    const direction
) const;

template<>
void GeometricgpuField<scalar, fvPatchgpuField, gpuvolMesh>::replace
(
    const direction,
    const GeometricgpuField<scalar, fvPatchgpuField, gpuvolMesh>& sf
);

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#include "volgpuFieldsI.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
