/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

InClass
    Foam::slicedSurfaceFields

\*---------------------------------------------------------------------------*/

#ifndef slicedSurfacegpuFields_H
#define slicedSurfacegpuFields_H

#include "SlicedGeometricgpuField.H"
#include "slicedFvsPatchgpuField.H"
#include "gpusurfaceMesh.H"
#include "slicedSurfacegpuFieldsFwd.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<>
inline void
SlicedGeometricgpuField<scalar, fvsPatchgpuField, slicedFvsPatchgpuField, gpusurfaceMesh>::
correctBoundaryConditions()
{}

template<>
inline void
SlicedGeometricgpuField<vector, fvsPatchgpuField, slicedFvsPatchgpuField, gpusurfaceMesh>::
correctBoundaryConditions()
{}

template<>
inline void
SlicedGeometricgpuField
<
    sphericalTensor,
    fvsPatchgpuField,
    slicedFvsPatchgpuField,
    gpusurfaceMesh
>::
correctBoundaryConditions()
{}

template<>
inline void
SlicedGeometricgpuField
<
    symmTensor,
    fvsPatchgpuField,
    slicedFvsPatchgpuField,
    gpusurfaceMesh
>::
correctBoundaryConditions()
{}

template<>
inline void
SlicedGeometricgpuField<tensor, fvsPatchgpuField, slicedFvsPatchgpuField, gpusurfaceMesh>::
correctBoundaryConditions()
{}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
