/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::wedgeFvsPatchgpuField

Description
    Foam::wedgeFvsPatchgpuField

SourceFiles
    wedgeFvsPatchgpuField.C

\*---------------------------------------------------------------------------*/

#ifndef wedgeFvsPatchgpuField_H
#define wedgeFvsPatchgpuField_H

#include "fvsPatchgpuField.H"
#include "wedgegpuFvPatch.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                         Class wedgeFvsPatch Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class wedgeFvsPatchgpuField
:
    public fvsPatchgpuField<Type>
{

public:

    //- Runtime type information
    TypeName(wedgegpuFvPatch::typeName_());


    // Constructors

        //- Construct from patch and internal field
        wedgeFvsPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&
        );

        //- Construct from patch, internal field and dictionary
        wedgeFvsPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&,
            const dictionary&
        );

        //- Construct by mapping given wedgeFvsPatchgpuField onto a new patch
        wedgeFvsPatchgpuField
        (
            const wedgeFvsPatchgpuField<Type>&,
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        wedgeFvsPatchgpuField
        (
            const wedgeFvsPatchgpuField<Type>&
        );

        //- Construct and return a clone
        virtual tmp<fvsPatchgpuField<Type>> clone() const
        {
            return tmp<fvsPatchgpuField<Type>>
            (
                new wedgeFvsPatchgpuField<Type>(*this)
            );
        }

        //- Construct as copy setting internal field reference
        wedgeFvsPatchgpuField
        (
            const wedgeFvsPatchgpuField<Type>&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvsPatchgpuField<Type>> clone
        (
            const DimensionedgpuField<Type, gpusurfaceMesh>& iF
        ) const
        {
            return tmp<fvsPatchgpuField<Type>>
            (
                new wedgeFvsPatchgpuField<Type>(*this, iF)
            );
        }
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "wedgeFvsPatchgpuField.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
