/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::emptyFvsPatchgpuField

Description
    Foam::emptyFvsPatchgpuField

SourceFiles
    emptyFvsPatchgpuField.C

\*---------------------------------------------------------------------------*/

#ifndef emptyFvsPatchgpuField_H
#define emptyFvsPatchgpuField_H

#include "fvsPatchgpuField.H"
#include "emptygpuFvPatch.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                         Class emptyFvsPatch Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class emptyFvsPatchgpuField
:
    public fvsPatchgpuField<Type>
{

public:

    //- Runtime type information
    TypeName(emptygpuFvPatch::typeName_());


    // Constructors

        //- Construct from patch and internal field
        emptyFvsPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&
        );

        //- Construct from patch, internal field and dictionary
        emptyFvsPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&,
            const dictionary&
        );

        //- Construct by mapping given emptyFvsPatchgpuField onto a new patch
        emptyFvsPatchgpuField
        (
            const emptyFvsPatchgpuField<Type>&,
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        emptyFvsPatchgpuField
        (
            const emptyFvsPatchgpuField<Type>&
        );

        //- Construct and return a clone
        virtual tmp<fvsPatchgpuField<Type>> clone() const
        {
            return tmp<fvsPatchgpuField<Type>>
            (
                new emptyFvsPatchgpuField<Type>(*this)
            );
        }

        //- Construct as copy setting internal field reference
        emptyFvsPatchgpuField
        (
            const emptyFvsPatchgpuField<Type>&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvsPatchgpuField<Type>> clone
        (
            const DimensionedgpuField<Type, gpusurfaceMesh>& iF
        ) const
        {
            return tmp<fvsPatchgpuField<Type>>
            (
                new emptyFvsPatchgpuField<Type>(*this, iF)
            );
        }


    // Member functions

        // Mapping functions

            //- Map (and resize as needed) from self given a mapping object
            virtual void autoMap
            (
                const fvPatchgpuFieldMapper&
            )
            {}

            //- Reverse map the given fvsPatchgpuField onto this fvsPatchgpuField
            virtual void rmap
            (
                const fvsPatchgpuField<Type>&,
                const labelgpuList&
            )
            {}
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "emptyFvsPatchgpuField.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
