/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::cyclicAMIFvsPatchField

Description
    Foam::cyclicAMIFvsPatchField

SourceFiles
    cyclicAMIFvsPatchField.C

\*---------------------------------------------------------------------------*/

#ifndef cyclicAMIFvsPatchgpuField_H
#define cyclicAMIFvsPatchgpuField_H

#include "coupledFvsPatchgpuField.H"
#include "cyclicAMIgpuFvPatch.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                    Class cyclicAMIFvsPatchField Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class cyclicAMIFvsPatchgpuField
:
    public coupledFvsPatchgpuField<Type>
{
    // Private data

        //- Local reference cast into the cyclic patch
        const cyclicAMIgpuFvPatch& cyclicAMIPatch_;


public:

    //- Runtime type information
    TypeName(cyclicAMIgpuFvPatch::typeName_());


    // Constructors

        //- Construct from patch and internal field
        cyclicAMIFvsPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&
        );

        //- Construct from patch, internal field and dictionary
        cyclicAMIFvsPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&,
            const dictionary&
        );

        //- Construct by mapping given cyclicAMIFvsPatchField onto a new patch
        cyclicAMIFvsPatchgpuField
        (
            const cyclicAMIFvsPatchgpuField<Type>&,
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        cyclicAMIFvsPatchgpuField
        (
            const cyclicAMIFvsPatchgpuField<Type>&
        );

        //- Construct and return a clone
        virtual tmp<fvsPatchgpuField<Type>> clone() const
        {
            return tmp<fvsPatchgpuField<Type>>
            (
                new cyclicAMIFvsPatchgpuField<Type>(*this)
            );
        }

        //- Construct as copy setting internal field reference
        cyclicAMIFvsPatchgpuField
        (
            const cyclicAMIFvsPatchgpuField<Type>&,
            const DimensionedgpuField<Type, gpusurfaceMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvsPatchgpuField<Type>> clone
        (
            const DimensionedgpuField<Type, gpusurfaceMesh>& iF
        ) const
        {
            return tmp<fvsPatchgpuField<Type>>
            (
                new cyclicAMIFvsPatchgpuField<Type>(*this, iF)
            );
        }

    // Member functions

        // Access

            //- Return true if running parallel
            virtual bool coupled() const;

};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "cyclicAMIFvsPatchgpuField.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
