/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "coupledFvsPatchgpuField.H"

// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
Foam::coupledFvsPatchgpuField<Type>::coupledFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
)
:
    fvsPatchgpuField<Type>(p, iF)
{}


template<class Type>
Foam::coupledFvsPatchgpuField<Type>::coupledFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const gpuField<Type>& f
)
:
    fvsPatchgpuField<Type>(p, iF, f)
{}


template<class Type>
Foam::coupledFvsPatchgpuField<Type>::coupledFvsPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const dictionary& dict
)
:
    fvsPatchgpuField<Type>(p, iF, dict)
{}


template<class Type>
Foam::coupledFvsPatchgpuField<Type>::coupledFvsPatchgpuField
(
    const coupledFvsPatchgpuField<Type>& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fvsPatchgpuField<Type>(ptf, p, iF, mapper)
{}


template<class Type>
Foam::coupledFvsPatchgpuField<Type>::coupledFvsPatchgpuField
(
    const coupledFvsPatchgpuField<Type>& ptf
)
:
    fvsPatchgpuField<Type>(ptf)
{}


template<class Type>
Foam::coupledFvsPatchgpuField<Type>::coupledFvsPatchgpuField
(
    const coupledFvsPatchgpuField<Type>& ptf,
    const DimensionedgpuField<Type, gpusurfaceMesh>& iF
)
:
    fvsPatchgpuField<Type>(ptf, iF)
{}


// ************************************************************************* //
