/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2013 OpenFOAM Foundation
    Copyright (C) 2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::directFvPatchgpuFieldMapper

Description
    direct fvPatchgpuFieldMapper

\*---------------------------------------------------------------------------*/

#ifndef directFvPatchgpuFieldMapper_H
#define directFvPatchgpuFieldMapper_H

#include "fvPatchgpuFieldMapper.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                       Class directFvPatchgpuFieldMapper Declaration
\*---------------------------------------------------------------------------*/

class directFvPatchgpuFieldMapper
:
    public fvPatchgpuFieldMapper
{

    //- Addressing from new back to old
    const labelgpuList& directAddressing_;

    //- Does map contain any unmapped values
    bool hasUnmapped_;


public:

    // Constructors

        //- Construct given addressing
        directFvPatchgpuFieldMapper(const labelUList& directAddressing)
        :
            directAddressing_(directAddressing),
            hasUnmapped_(directAddressing_.size() && min(directAddressing_) < 0)
        {}

        directFvPatchgpuFieldMapper(const labelgpuList& directAddressing)
        :
            directAddressing_(directAddressing),
            hasUnmapped_(directAddressing_.size() && min(directAddressing_) < 0)
        {}


    //- Destructor
    virtual ~directFvPatchgpuFieldMapper() = default;


    // Member Functions

        label size() const
        {
            return directAddressing_.size();
        }

        bool direct() const
        {
            return true;
        }

        bool hasUnmapped() const
        {
            return hasUnmapped_;
        }

        bool& hasUnmapped()
        {
            return hasUnmapped_;
        }

        const labelgpuList& directAddressing() const
        {
            return directAddressing_;
        }
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
