/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2015-2021 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::movingWallVelocityFvPatchVectorField

Group
    grpWallBoundaryConditions

Description
    This boundary condition provides a velocity condition for cases with
    moving walls.

Usage
    Example of the boundary condition specification:
    \verbatim
    <patchName>
    {
        type            movingWallVelocity;
        value           uniform (0 0 0);    // Initial value
    }
    \endverbatim

See also
    Foam::fixedValueFvPatchVectorField
    Foam::MRFZone

SourceFiles
    movingWallVelocityFvPatchVectorField.C

\*---------------------------------------------------------------------------*/

#ifndef movingWallVelocityFvPatchVectorgpuField_H
#define movingWallVelocityFvPatchVectorgpuField_H

#include "fixedValueFvPatchgpuFields.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
             Class movingWallVelocityFvPatchVectorField Declaration
\*---------------------------------------------------------------------------*/

class movingWallVelocityFvPatchVectorgpuField
:
    public fixedValueFvPatchVectorgpuField
{
public:

    //- Runtime type information
    TypeName("movingWallVelocity");


    // Constructors

        //- Construct from patch and internal field
        movingWallVelocityFvPatchVectorgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<vector, gpuvolMesh>&
        );

        //- Construct from patch, internal field and dictionary
        movingWallVelocityFvPatchVectorgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<vector, gpuvolMesh>&,
            const dictionary&
        );

        //- Construct by mapping given movingWallVelocityFvPatchVectorField
        //  onto a new patch
        movingWallVelocityFvPatchVectorgpuField
        (
            const movingWallVelocityFvPatchVectorgpuField&,
            const gpufvPatch&,
            const DimensionedgpuField<vector, gpuvolMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        movingWallVelocityFvPatchVectorgpuField
        (
            const movingWallVelocityFvPatchVectorgpuField&
        );

        //- Construct and return a clone
        virtual tmp<fvPatchVectorgpuField> clone() const
        {
            return tmp<fvPatchVectorgpuField>
            (
                new movingWallVelocityFvPatchVectorgpuField(*this)
            );
        }

        //- Construct as copy setting internal field reference
        movingWallVelocityFvPatchVectorgpuField
        (
            const movingWallVelocityFvPatchVectorgpuField&,
            const DimensionedgpuField<vector, gpuvolMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvPatchVectorgpuField> clone
        (
            const DimensionedgpuField<vector, gpuvolMesh>& iF
        ) const
        {
            return tmp<fvPatchVectorgpuField>
            (
                new movingWallVelocityFvPatchVectorgpuField(*this, iF)
            );
        }


    // Member Functions

        //- Return wall velocity field
        tmp<vectorgpuField> Uwall() const;

        //- Update the coefficients associated with the patch field
        virtual void updateCoeffs();

        //- Write
        virtual void write(Ostream&) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
