/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "fixedFluxExtrapolatedPressureFvPatchScalargpuField.H"
#include "addToRunTimeSelectionTable.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::fixedFluxExtrapolatedPressureFvPatchScalargpuField::
fixedFluxExtrapolatedPressureFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedFluxPressureFvPatchScalargpuField(p, iF)
{}


Foam::fixedFluxExtrapolatedPressureFvPatchScalargpuField::
fixedFluxExtrapolatedPressureFvPatchScalargpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    fixedFluxPressureFvPatchScalargpuField(p, iF, dict)
{}


Foam::fixedFluxExtrapolatedPressureFvPatchScalargpuField::
fixedFluxExtrapolatedPressureFvPatchScalargpuField
(
    const fixedFluxExtrapolatedPressureFvPatchScalargpuField& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fixedFluxPressureFvPatchScalargpuField(ptf, p, iF, mapper)
{}


Foam::fixedFluxExtrapolatedPressureFvPatchScalargpuField::
fixedFluxExtrapolatedPressureFvPatchScalargpuField
(
    const fixedFluxExtrapolatedPressureFvPatchScalargpuField& wbppsf
)
:
    fixedFluxPressureFvPatchScalargpuField(wbppsf)
{}


Foam::fixedFluxExtrapolatedPressureFvPatchScalargpuField::
fixedFluxExtrapolatedPressureFvPatchScalargpuField
(
    const fixedFluxExtrapolatedPressureFvPatchScalargpuField& wbppsf,
    const DimensionedgpuField<scalar, gpuvolMesh>& iF
)
:
    fixedFluxPressureFvPatchScalargpuField(wbppsf, iF)
{}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
    makePatchTypeField
    (
        fvPatchScalargpuField,
        fixedFluxExtrapolatedPressureFvPatchScalargpuField
    );
}


// ************************************************************************* //
