/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2017 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::wedgeFvPatchgpuField

Group
    grpConstraintBoundaryConditions

Description
    This boundary condition is similar to the cyclic condition, except that
    it is applied to 2-D geometries.

Usage
    Example of the boundary condition specification:
    \verbatim
    <patchName>
    {
        type            wedge;
    }
    \endverbatim

See also
    Foam::cyclicFvPatchgpuField

SourceFiles
    wedgeFvPatchgpuField.C

\*---------------------------------------------------------------------------*/

#ifndef wedgeFvPatchgpuField_H
#define wedgeFvPatchgpuField_H

#include "transformFvPatchgpuField.H"
#include "wedgegpuFvPatch.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                       Class wedgeFvPatchgpuField Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class wedgeFvPatchgpuField
:
    public transformFvPatchgpuField<Type>
{

public:

    //- Runtime type information
    TypeName(wedgegpuFvPatch::typeName_());


    // Constructors

        //- Construct from patch and internal field
        wedgeFvPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpuvolMesh>&
        );

        //- Construct from patch, internal field and dictionary
        wedgeFvPatchgpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpuvolMesh>&,
            const dictionary&
        );

        //- Construct by mapping given wedgeFvPatchgpuField onto a new patch
        wedgeFvPatchgpuField
        (
            const wedgeFvPatchgpuField<Type>&,
            const gpufvPatch&,
            const DimensionedgpuField<Type, gpuvolMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        wedgeFvPatchgpuField
        (
            const wedgeFvPatchgpuField<Type>&
        );

        //- Construct and return a clone
        virtual tmp<fvPatchgpuField<Type>> clone() const
        {
            return tmp<fvPatchgpuField<Type>>
            (
                new wedgeFvPatchgpuField<Type>(*this)
            );
        }

        //- Construct as copy setting internal field reference
        wedgeFvPatchgpuField
        (
            const wedgeFvPatchgpuField<Type>&,
            const DimensionedgpuField<Type, gpuvolMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvPatchgpuField<Type>> clone
        (
            const DimensionedgpuField<Type, gpuvolMesh>& iF
        ) const
        {
            return tmp<fvPatchgpuField<Type>>
            (
                new wedgeFvPatchgpuField<Type>(*this, iF)
            );
        }


    // Member functions

        //- Return gradient at boundary
        virtual tmp<gpuField<Type>> snGrad() const;

        //- Evaluate the patch field
        virtual void evaluate
        (
            const Pstream::commsTypes commsType=Pstream::commsTypes::blocking
        );

        //- Return face-gradient transform diagonal
        virtual tmp<gpuField<Type>> snGradTransformDiag() const;
};


// * * * * * * * * * * * Template Specialisations  * * * * * * * * * * * * * //

template<>
tmp<scalargpuField> wedgeFvPatchgpuField<scalar>::snGrad() const;

template<>
void wedgeFvPatchgpuField<scalar>::evaluate
(
    const Pstream::commsTypes commsType
);


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "wedgeFvPatchgpuField.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
