/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "extrapolatedCalculatedFvPatchgpuField.H"
#include "fvPatchgpuFieldMapper.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

template<class Type>
Foam::extrapolatedCalculatedFvPatchgpuField<Type>::
extrapolatedCalculatedFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF
)
:
    calculatedFvPatchgpuField<Type>(p, iF)
{}


template<class Type>
Foam::extrapolatedCalculatedFvPatchgpuField<Type>::
extrapolatedCalculatedFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const dictionary& dict
)
:
    calculatedFvPatchgpuField<Type>(p, iF, dict, false)
{
    evaluate();
}


template<class Type>
Foam::extrapolatedCalculatedFvPatchgpuField<Type>::
extrapolatedCalculatedFvPatchgpuField
(
    const extrapolatedCalculatedFvPatchgpuField<Type>& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    calculatedFvPatchgpuField<Type>(ptf, p, iF, mapper)
{}


template<class Type>
Foam::extrapolatedCalculatedFvPatchgpuField<Type>::
extrapolatedCalculatedFvPatchgpuField
(
    const extrapolatedCalculatedFvPatchgpuField<Type>& ptf
)
:
    calculatedFvPatchgpuField<Type>(ptf)
{}


template<class Type>
Foam::extrapolatedCalculatedFvPatchgpuField<Type>::
extrapolatedCalculatedFvPatchgpuField
(
    const extrapolatedCalculatedFvPatchgpuField<Type>& ptf,
    const DimensionedgpuField<Type, gpuvolMesh>& iF
)
:
    calculatedFvPatchgpuField<Type>(ptf, iF)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
void Foam::extrapolatedCalculatedFvPatchgpuField<Type>::evaluate
(
    const Pstream::commsTypes
)
{
    if (!this->updated())
    {
        this->updateCoeffs();
    }

    calculatedFvPatchgpuField<Type>::operator==(this->patchInternalField());
    calculatedFvPatchgpuField<Type>::evaluate();
}


// ************************************************************************* //
