/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2021 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "calculatedFvPatchgpuField.H"
#include "fvPatchgpuFieldMapper.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type>
const Foam::word& Foam::fvPatchgpuField<Type>::calculatedType()
{
    return calculatedFvPatchgpuField<Type>::typeName;
}


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

template<class Type>
Foam::calculatedFvPatchgpuField<Type>::calculatedFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF
)
:
    fvPatchgpuField<Type>(p, iF)
{}


template<class Type>
Foam::calculatedFvPatchgpuField<Type>::calculatedFvPatchgpuField
(
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const dictionary& dict,
    const bool valueRequired
)
:
    fvPatchgpuField<Type>(p, iF, dict, valueRequired)
{}


template<class Type>
Foam::calculatedFvPatchgpuField<Type>::calculatedFvPatchgpuField
(
    const calculatedFvPatchgpuField<Type>& ptf,
    const gpufvPatch& p,
    const DimensionedgpuField<Type, gpuvolMesh>& iF,
    const fvPatchgpuFieldMapper& mapper
)
:
    fvPatchgpuField<Type>(ptf, p, iF, mapper)
{}


template<class Type>
Foam::calculatedFvPatchgpuField<Type>::calculatedFvPatchgpuField
(
    const calculatedFvPatchgpuField<Type>& ptf
)
:
    fvPatchgpuField<Type>(ptf)
{}


template<class Type>
Foam::calculatedFvPatchgpuField<Type>::calculatedFvPatchgpuField
(
    const calculatedFvPatchgpuField<Type>& ptf,
    const DimensionedgpuField<Type, gpuvolMesh>& iF
)
:
    fvPatchgpuField<Type>(ptf, iF)
{}


template<class Type>
Foam::tmp<Foam::fvPatchgpuField<Type>>
Foam::fvPatchgpuField<Type>::NewCalculatedType
(
    const gpufvPatch& p
)
{
    auto* patchTypeCtor = patchConstructorTable(p.type());

    if (patchTypeCtor)
    {
        return patchTypeCtor
        (
            p,
            DimensionedgpuField<Type, gpuvolMesh>::null()
        );
    }
    else
    {
        return tmp<fvPatchgpuField<Type>>
        (
            new calculatedFvPatchgpuField<Type>
            (
                p,
                DimensionedgpuField<Type, gpuvolMesh>::null()
            )
        );
    }
}


template<class Type>
template<class Type2>
Foam::tmp<Foam::fvPatchgpuField<Type>> Foam::fvPatchgpuField<Type>::NewCalculatedType
(
    const fvPatchgpuField<Type2>& pf
)
{
    return NewCalculatedType(pf.patch());
}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::calculatedFvPatchgpuField<Type>::valueInternalCoeffs
(
    const tmp<scalargpuField>&
) const
{
    FatalErrorInFunction
        << "cannot be called for a calculatedFvPatchgpuField"
        << "\n    on patch " << this->patch().name()
//        << " of field " << this->internalField().name()
//        << " in file " << this->internalField().objectPath()
        << "\n    You are probably trying to solve for a field with a "
           "default boundary condition."
        << abort(FatalError);

    return *this;
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::calculatedFvPatchgpuField<Type>::valueBoundaryCoeffs
(
    const tmp<scalargpuField>&
) const
{
    FatalErrorInFunction
        << "cannot be called for a calculatedFvPatchgpuField"
        << "\n    on patch " << this->patch().name()
//        << " of field " << this->internalField().name()
//        << " in file " << this->internalField().objectPath()
        << "\n    You are probably trying to solve for a field with a "
           "default boundary condition."
        << abort(FatalError);

    return *this;
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::calculatedFvPatchgpuField<Type>::gradientInternalCoeffs() const
{
    FatalErrorInFunction
        << "cannot be called for a calculatedFvPatchgpuField"
        << "\n    on patch " << this->patch().name()
//        << " of field " << this->internalField().name()
//        << " in file " << this->internalField().objectPath()
        << "\n    You are probably trying to solve for a field with a "
           "default boundary condition."
        << abort(FatalError);

    return *this;
}


template<class Type>
Foam::tmp<Foam::gpuField<Type>>
Foam::calculatedFvPatchgpuField<Type>::gradientBoundaryCoeffs() const
{
    FatalErrorInFunction
        << "cannot be called for a calculatedFvPatchgpuField"
        << "\n    on patch " << this->patch().name()
//        << " of field " << this->internalField().name()
//        << " in file " << this->internalField().objectPath()
        << "\n    You are probably trying to solve for a field with a "
           "default boundary condition."
        << abort(FatalError);

    return *this;
}


template<class Type>
void Foam::calculatedFvPatchgpuField<Type>::write(Ostream& os) const
{
    fvPatchgpuField<Type>::write(os);
    this->writeEntry("value", os);
}


// ************************************************************************* //
