/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2021 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::fv::gpudfsolverSnGrad

Group
    grpFvSnGradSchemes

Description
    

Usage
    Minimal example by using \c system/fvSchemes:
    \verbatim
    snGradSchemes
    {
        snGrad(<term>)       dfsolver;
    }
    \endverbatim

SourceFiles
    

\*---------------------------------------------------------------------------*/

#ifndef gpudfsolverSnGrad_H
#define gpudfsolverSnGrad_H

#include "gpusnGradScheme.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace fv
{

/*---------------------------------------------------------------------------*\
                        Class gpudfsolverSnGrad Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class gpudfsolverSnGrad
:
    public gpusnGradScheme<Type>
{
    // Private Member Functions

        //- No copy assignment
        void operator=(const gpudfsolverSnGrad&) = delete;


public:

    //- Runtime type information
    TypeName("dfsolver");


    // Constructors

        //- Construct from mesh
        gpudfsolverSnGrad(const gpufvMesh& mesh)
        :
            gpusnGradScheme<Type>(mesh)
        {}

        //- Construct from mesh and data stream
        gpudfsolverSnGrad(const gpufvMesh& mesh, Istream&)
        :
            gpusnGradScheme<Type>(mesh)
        {}


    //- Destructor
    virtual ~gpudfsolverSnGrad() = default;


    // Member Functions

        //- Return the interpolation weighting factors for the given field
        virtual tmp<surfaceScalargpuField> deltaCoeffs
        (
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        ) const
        {
            return this->mesh().nonOrthDeltaCoeffs();
        }

        //- Return true if this scheme uses an explicit correction
        virtual bool corrected() const noexcept
        {
            return true;
        }

        //- Return the explicit correction to the dfsolverSnGrad
        //- for the given field using the gradient of the field
        tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>>
        fullGradCorrection
        (
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        ) const;

        //- Return the explicit correction to the dfsolverSnGrad
        //- for the given field using the gradients of the field components
        virtual tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>>
        correction(const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&) const;
};


// * * * * * * * * Template Member Function Specialisations  * * * * * * * * //

template<>
tmp<surfaceScalargpuField> gpudfsolverSnGrad<scalar>::correction
(
    const volScalargpuField& vsf
) const;


template<>
tmp<surfaceVectorgpuField> gpudfsolverSnGrad<vector>::correction
(
    const volVectorgpuField& vvf
) const;


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fv

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "gpudfsolverSnGrad.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
