/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

InNamespace
    Foam::fvc

Description
    Calculate the snGrad of the given volField.

SourceFiles
    fvcSnGrad.C

\*---------------------------------------------------------------------------*/


#ifndef gpufvcSnGrad_H
#define gpufvcSnGrad_H

#include "volgpuFieldsFwd.H"
#include "surfacegpuFieldsFwd.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                     Namespace fvc functions Declaration
\*---------------------------------------------------------------------------*/

namespace fvc
{
    template<class Type>
    tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> snGrad
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word& name
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> snGrad
    (
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&,
        const word& name
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> snGrad
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> snGrad
    (
        const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>&
    );
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "gpufvcSnGrad.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
