/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gpufvcDiv.H"
#include "gpufvMesh.H"
#include "gpufvcSurfaceIntegrate.H"
#include "gpudivScheme.H"
#include "gpuconvectionScheme.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace fvc
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
div
(
    const GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>& ssf
)
{
    return tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
    (
        new GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>
        (
            "div("+ssf.name()+')',
            fvc::surfaceIntegrate(ssf)
        )
    );
}


template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
div
(
    const tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>>& tssf
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Div(fvc::div(tssf()));
    tssf.clear();
    return Div;
}


template<class Type>
tmp
<
    GeometricgpuField
    <
        typename innerProduct<vector, Type>::type, fvPatchgpuField, gpuvolMesh
    >
>
div
(
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf,
    const word& name
)
{
    return fv::gpudivScheme<Type>::New
    (
        vf.mesh(), vf.mesh().hostmesh().divScheme(name)
    ).ref().fvcDiv(vf);
}


template<class Type>
tmp
<
    GeometricgpuField
    <
        typename innerProduct<vector, Type>::type, fvPatchgpuField, gpuvolMesh
    >
>
div
(
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvvf,
    const word& name
)
{
    typedef typename innerProduct<vector, Type>::type DivType;
    tmp<GeometricgpuField<DivType, fvPatchgpuField, gpuvolMesh>> Div
    (
        fvc::div(tvvf(), name)
    );
    tvvf.clear();
    return Div;
}

template<class Type>
tmp
<
    GeometricgpuField
    <
        typename innerProduct<vector, Type>::type, fvPatchgpuField, gpuvolMesh
    >
>
div
(
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return fvc::div(vf, "div("+vf.name()+')');
}


template<class Type>
tmp
<
    GeometricgpuField
    <
        typename innerProduct<vector, Type>::type, fvPatchgpuField, gpuvolMesh
    >
>
div
(
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvvf
)
{
    typedef typename innerProduct<vector, Type>::type DivType;
    tmp<GeometricgpuField<DivType, fvPatchgpuField, gpuvolMesh>> Div(fvc::div(tvvf()));
    tvvf.clear();
    return Div;
}


template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
div
(
    const surfaceScalargpuField& flux,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf,
    const word& name
)
{
    return fv::gpuconvectionScheme<Type>::New
    (
        vf.mesh(),
        flux,
        vf.mesh().hostmesh().divScheme(name)
    ).ref().fvcDiv(flux, vf);
}


template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
div
(
    const tmp<surfaceScalargpuField>& tflux,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf,
    const word& name
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Div
    (
        fvc::div(tflux(), vf, name)
    );
    tflux.clear();
    return Div;
}


template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
div
(
    const surfaceScalargpuField& flux,
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf,
    const word& name
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Div
    (
        fvc::div(flux, tvf(), name)
    );
    tvf.clear();
    return Div;
}


template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
div
(
    const tmp<surfaceScalargpuField>& tflux,
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf,
    const word& name
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Div
    (
        fvc::div(tflux(), tvf(), name)
    );
    tflux.clear();
    tvf.clear();
    return Div;
}


template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
div
(
    const surfaceScalargpuField& flux,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return fvc::div
    (
        flux, vf, "div("+flux.name()+','+vf.name()+')'
    );
}


template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
div
(
    const tmp<surfaceScalargpuField>& tflux,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Div
    (
        fvc::div(tflux(), vf)
    );
    tflux.clear();
    return Div;
}


template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
div
(
    const surfaceScalargpuField& flux,
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Div
    (
        fvc::div(flux, tvf())
    );
    tvf.clear();
    return Div;
}


template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
div
(
    const tmp<surfaceScalargpuField>& tflux,
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf
)
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> Div
    (
        fvc::div(tflux(), tvf())
    );
    tflux.clear();
    tvf.clear();
    return Div;
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fvc

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// ************************************************************************* //
