/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2015-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gpulocalEulerDdtScheme.H"
#include "gpufvMesh.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

Foam::word Foam::fv::gpulocalEulerDdt::rDeltaTName("rDeltaT");
Foam::word Foam::fv::gpulocalEulerDdt::rDeltaTfName("rDeltaTf");
Foam::word Foam::fv::gpulocalEulerDdt::rSubDeltaTName("rSubDeltaT");

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

bool Foam::fv::gpulocalEulerDdt::enabled(const gpufvMesh& mesh)
{
    return
        word(mesh.hostmesh().ddtScheme("default"))
     == fv::gpulocalEulerDdtScheme<scalar>::typeName;
}


const Foam::volScalargpuField& Foam::fv::gpulocalEulerDdt::localRDeltaT
(
    const gpufvMesh& mesh
)
{
    return mesh.hostmesh().objectRegistry::lookupObject<volScalargpuField>
    (
        mesh.time().subCycling() ? rSubDeltaTName : rDeltaTName
    );
}


const Foam::surfaceScalargpuField& Foam::fv::gpulocalEulerDdt::localRDeltaTf
(
    const gpufvMesh& mesh
)
{
    return mesh.hostmesh().objectRegistry::lookupObject<surfaceScalargpuField>
    (
        rDeltaTfName
    );
}


Foam::tmp<Foam::volScalargpuField> Foam::fv::gpulocalEulerDdt::localRSubDeltaT
(
    const gpufvMesh& mesh,
    const label nAlphaSubCycles
)
{
    return tmp<volScalargpuField>
    (
        new volScalargpuField
        (
            rSubDeltaTName,
            nAlphaSubCycles
           *mesh.hostmesh().objectRegistry::lookupObject<volScalargpuField>
            (
                rDeltaTName
            )
        )
    );
}


// ************************************************************************* //
