/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gpugaussConvectionScheme.H"
#include "gpufvcSurfaceIntegrate.H"
#include "gpufvMatrices.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace fv
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type>
const gpusurfaceInterpolationScheme<Type>&
gpugaussConvectionScheme<Type>::interpScheme() const
{
    return tinterpScheme_();
}


template<class Type>
tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>>
gpugaussConvectionScheme<Type>::interpolate
(
    const surfaceScalargpuField&,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
) const
{
    return tinterpScheme_().interpolate(vf);
}


template<class Type>
tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>>
gpugaussConvectionScheme<Type>::flux
(
    const surfaceScalargpuField& faceFlux,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
) const
{
    return faceFlux*interpolate(faceFlux, vf);
}


template<class Type>
tmp<gpufvMatrix<Type>>
gpugaussConvectionScheme<Type>::fvmDiv
(
    const surfaceScalargpuField& faceFlux,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
) const
{
    tmp<surfaceScalargpuField> tweights = tinterpScheme_().weights(vf);
    const surfaceScalargpuField& weights = tweights();

    tmp<gpufvMatrix<Type>> tfvm
    (
        new gpufvMatrix<Type>
        (
            vf,
            faceFlux.dimensions()*vf.dimensions()
        )
    );
    gpufvMatrix<Type>& fvm = tfvm.ref();

    fvm.gpuLower() = -(weights.primitiveField()*faceFlux.primitiveField());
    fvm.gpuUpper() = fvm.gpuLower() + faceFlux.primitiveField();
    fvm.negSumDiag();

    forAll(vf.boundaryField(), patchi)
    {
        const fvPatchgpuField<Type>& psf = vf.boundaryField()[patchi];
        const fvsPatchScalargpuField& patchFlux = faceFlux.boundaryField()[patchi];
        const fvsPatchScalargpuField& pw = weights.boundaryField()[patchi];

        fvm.internalCoeffs()[patchi] = patchFlux*psf.valueInternalCoeffs(pw);
        fvm.boundaryCoeffs()[patchi] = -patchFlux*psf.valueBoundaryCoeffs(pw);
    }

    if (tinterpScheme_().corrected())
    {
        fvm += fvc::surfaceIntegrate(faceFlux*tinterpScheme_().correction(vf));
    }

    return tfvm;
}


template<class Type>
tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>
gpugaussConvectionScheme<Type>::fvcDiv
(
    const surfaceScalargpuField& faceFlux,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
) const
{
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> tConvection
    (
        fvc::surfaceIntegrate(flux(faceFlux, vf))
    );

    tConvection.ref().rename
    (
        "convection(" + faceFlux.name() + ',' + vf.name() + ')'
    );

    return tConvection;
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fv

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// ************************************************************************* //
