/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::fv::gpudfsolverConvectionScheme

Group
    grpFvConvectionSchemes

Description
    

SourceFiles


\*---------------------------------------------------------------------------*/

#ifndef gpudfsolverConvectionScheme_H
#define gpudfsolverConvectionScheme_H

#include "gpuconvectionScheme.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace fv
{

/*---------------------------------------------------------------------------*\
                       Class xxxConvectionScheme Declaration
\*---------------------------------------------------------------------------*/

template<class Type>
class gpudfsolverConvectionScheme
:
    public fv::gpuconvectionScheme<Type>
{
    // Private data

        tmp<gpusurfaceInterpolationScheme<Type>> tinterpScheme_;


    // Private Member Functions

        //- No copy construct
        gpudfsolverConvectionScheme(const gpudfsolverConvectionScheme&) = delete;

        //- No copy assignment
        void operator=(const gpudfsolverConvectionScheme&) = delete;


public:

    //- Runtime type information
    TypeName("dfsolver");


    // Constructors

        //- Construct from flux and interpolation scheme
        gpudfsolverConvectionScheme
        (
            const gpufvMesh& mesh,
            const surfaceScalargpuField& faceFlux,
            const tmp<gpusurfaceInterpolationScheme<Type>>& scheme
        )
        :
            gpuconvectionScheme<Type>(mesh, faceFlux),
            tinterpScheme_(scheme)
        {}

        //- Construct from flux and Istream
        gpudfsolverConvectionScheme
        (
            const gpufvMesh& mesh,
            const surfaceScalargpuField& faceFlux,
            Istream& is
        )
        :
            gpuconvectionScheme<Type>(mesh, faceFlux),
            tinterpScheme_
            (
                gpusurfaceInterpolationScheme<Type>::New(mesh, faceFlux, is)
            )
        {}


    // Member Functions

        const gpusurfaceInterpolationScheme<Type>& interpScheme() const;

        tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> interpolate
        (
            const surfaceScalargpuField&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        ) const;

        tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> flux
        (
            const surfaceScalargpuField&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        ) const;

        tmp<gpufvMatrix<Type>> fvmDiv
        (
            const surfaceScalargpuField&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        ) const;

        tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> fvcDiv
        (
            const surfaceScalargpuField&,
            const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
        ) const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fv

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "gpudfsolverConvectionScheme.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
