/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "GdiagonalPreconditioner.H"
#include "lduMatrixSolutionCache.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

namespace Foam
{
    defineTypeNameAndDebug(GdiagonalPreconditioner, 0);

    gpulduMatrix::preconditioner::
        addsymMatrixConstructorToTable<GdiagonalPreconditioner>
        addGdiagonalPreconditionerSymMatrixConstructorToTable_;

    gpulduMatrix::preconditioner::
        addasymMatrixConstructorToTable<GdiagonalPreconditioner>
        addGdiagonalPreconditionerAsymMatrixConstructorToTable_;
}


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::GdiagonalPreconditioner::GdiagonalPreconditioner
(
    const gpulduMatrix::solver& sol,
    const dictionary&
)
:
    gpulduMatrix::preconditioner(sol),
    rD
	(
		lduMatrixSolutionCache::first(sol.matrix().gpuDiag().size()),
		sol.matrix().gpuDiag().size()
	)
{
	const scalargpuField& Diag = solver_.matrix().gpuDiag();

    thrust::transform
    (
        Diag.begin(),
        Diag.end(),
        rD.begin(),
        divideOperatorSFFunctor<scalar,scalar,scalar>(1.0)
    );

}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

void Foam::GdiagonalPreconditioner::precondition
(
    scalargpuField& wA,
    const scalargpuField& rA,
    const direction
) const
{

	thrust::transform
    (
        rD.begin(),
        rD.end(),
        rA.begin(),
        wA.begin(),
        multiplyOperatorFunctor<scalar,scalar,scalar>()
    );

}

// ************************************************************************* //
