#ifndef lduMatrixSolverFunctors_H
#define lduMatrixSolverFunctors_H

namespace Foam
{

struct wAPlusBetaPAFunctor
{
    const scalar beta;

    wAPlusBetaPAFunctor(scalar _beta): beta(_beta) {}

    __host__ __device__
    scalar operator()(const scalar& wA, const scalar& pA)
    {
            return wA + beta*pA;
    }
};

struct psiPlusAlphaPAFunctor
{
    const scalar alpha;

    psiPlusAlphaPAFunctor(scalar _alpha): alpha(_alpha) {}

    __host__ __device__
    scalar operator()(const scalar& psi, const scalar& pA)
    {
            return psi + alpha*pA;
    }
};

struct rAMinusAlphaWAFunctor
{
    const scalar alpha;

    rAMinusAlphaWAFunctor(scalar _alpha): alpha(_alpha) {}

    __host__ __device__
    scalar operator()(const scalar& rA, const scalar& wA)
    {
            return rA - alpha*wA;
    }
};


//******************************************************************//

struct pAMinusOmegaAyAFunctor
{
    const scalar omega;

    pAMinusOmegaAyAFunctor(scalar _omega): omega(_omega) {}

    __host__ __device__
    scalar operator()(const scalar& pA, const scalar& AyA)
    {
            return pA - omega*AyA;
    }
};

struct rAPlusBetaPAFunctor
{
    const scalar beta;

    rAPlusBetaPAFunctor(scalar _beta): beta(_beta) {}

    __host__ __device__
    scalar operator()(const scalar& rA, const scalar& pA)
    {
            return rA + beta*pA;
    }
};

struct rAMinusAlphaAyAFunctor
{
    const scalar alpha;

    rAMinusAlphaAyAFunctor(scalar _alpha): alpha(_alpha) {}

    __host__ __device__
    scalar operator()(const scalar& rA, const scalar& AyA)
    {
            return rA - alpha*AyA;
    }
};

struct psiPlusAlphaYAFunctor
{
    const scalar alpha;

    psiPlusAlphaYAFunctor(scalar _alpha): alpha(_alpha) {}

    __host__ __device__
    scalar operator()(const scalar& psi, const scalar& yA)
    {
            return psi + alpha*yA;
    }
};

struct psiPlusOmegaZAFunctor
{
    const scalar omega;

    psiPlusOmegaZAFunctor(scalar _omega): omega(_omega) {}

    __host__ __device__
    scalar operator()(const scalar& psi, const scalar& zA)
    {
            return psi + omega*zA;
    }
};

struct sAMinusOmegaTAFunctor
{
    const scalar omega;

    sAMinusOmegaTAFunctor(scalar _omega): omega(_omega) {}

    __host__ __device__
    scalar operator()(const scalar& sA, const scalar& tA)
    {
            return sA - omega*tA;
    }
};



}

#endif
