/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2013 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::procLduMatrix

Description
    I/O for lduMatrix and interface values.

SourceFiles
    procLduMatrix.C

\*---------------------------------------------------------------------------*/

#ifndef procgpuLduMatrix_H
#define procgpuLduMatrix_H

#include "labelList.H"
#include "scalarField.H"
#include "FieldField.H"
#include "lduInterfacegpuFieldPtrsList.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

class procgpuLduInterface;
class gpulduMatrix;

// Forward declaration of friend functions and operators

class procgpuLduMatrix;

Ostream& operator<<(Ostream&, const procgpuLduMatrix&);


/*---------------------------------------------------------------------------*\
                           Class procLduMatrix Declaration
\*---------------------------------------------------------------------------*/

class procgpuLduMatrix
{
    // Private data

        labelList upperAddr_;
        labelList lowerAddr_;
        scalarField diag_;
        scalarField upper_;
        scalarField lower_;
        PtrList<procgpuLduInterface> interfaces_;


    // Private Member Functions

        //- No copy construct
        procgpuLduMatrix(const procgpuLduMatrix&) = delete;


public:

    friend class gpuLUscalarMatrix;


    // Constructors

        /*procgpuLduMatrix
        (
            const gpulduMatrix& ldum,
            const FieldField<Field, scalar>& interfaceCoeffs,
            const lduInterfacegpuFieldPtrsList& interfaces
        );*/

        procgpuLduMatrix
        (
            const gpulduMatrix& ldum,
            const FieldField<gpuField, scalar>& interfaceCoeffs,
            const lduInterfacegpuFieldPtrsList& interfaces
        );

        procgpuLduMatrix(Istream& is);


    // Member functions

        label size() const
        {
            return diag_.size();
        }


    // Ostream operator

        friend Ostream& operator<<(Ostream&, const procgpuLduMatrix&);
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
