/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "procgpuLduMatrix.H"
#include "procgpuLduInterface.H"
#include "gpulduMatrix.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

/*Foam::procgpuLduMatrix::procgpuLduMatrix
(
    const gpulduMatrix& ldum,
    const FieldField<Field, scalar>& interfaceCoeffs,
    const lduInterfacegpuFieldPtrsList& interfaces
)
:
    upperAddr_(ldum.lduAddr().upperAddr().size()),
    lowerAddr_(ldum.lduAddr().lowerAddr().size()),
    diag_(ldum.gpuDiag().size()),
    upper_(ldum.gpuUpper().size()),
    lower_(ldum.gpuLower().size())
{
    thrust::copy(ldum.lduAddr().upperAddr().begin(),ldum.lduAddr().upperAddr().end(),upperAddr_.begin());
    thrust::copy(ldum.lduAddr().lowerAddr().begin(),ldum.lduAddr().lowerAddr().end(),lowerAddr_.begin());
    thrust::copy(ldum.gpuDiag().begin(),ldum.gpuDiag().end(),diag_.begin());
    thrust::copy(ldum.gpuUpper().begin(),ldum.gpuUpper().end(),upper_.begin());
    thrust::copy(ldum.gpuLower().begin(),ldum.gpuLower().end(),lower_.begin());

    label nInterfaces = 0;

    forAll(interfaces, i)
    {
        if (interfaces.set(i))
        {
            nInterfaces++;
        }
    }

    interfaces_.setSize(nInterfaces);

    nInterfaces = 0;

    forAll(interfaces, i)
    {
        if (interfaces.set(i))
        {
            interfaces_.set
            (
                nInterfaces++,
                new procgpuLduInterface
                (
                    interfaces[i],
                    interfaceCoeffs[i]
                )
            );
        }
    }

}*/


Foam::procgpuLduMatrix::procgpuLduMatrix
(
    const gpulduMatrix& ldum,
    const FieldField<gpuField, scalar>& interfaceCoeffs,
    const lduInterfacegpuFieldPtrsList& interfaces
)
:
    upperAddr_(ldum.lduAddr().upperAddr().size()),
    lowerAddr_(ldum.lduAddr().lowerAddr().size()),
    diag_(ldum.gpuDiag().size()),
    upper_(ldum.gpuUpper().size()),
    lower_(ldum.gpuLower().size())
{
    thrust::copy(ldum.lduAddr().upperAddr().begin(),ldum.lduAddr().upperAddr().end(),upperAddr_.begin());
    thrust::copy(ldum.lduAddr().lowerAddr().begin(),ldum.lduAddr().lowerAddr().end(),lowerAddr_.begin());
    thrust::copy(ldum.gpuDiag().begin(),ldum.gpuDiag().end(),diag_.begin());
    thrust::copy(ldum.gpuUpper().begin(),ldum.gpuUpper().end(),upper_.begin());
    thrust::copy(ldum.gpuLower().begin(),ldum.gpuLower().end(),lower_.begin());

    label nInterfaces = 0;

    forAll(interfaces, i)
    {
        if (interfaces.set(i))
        {
            nInterfaces++;
        }
    }

    interfaces_.setSize(nInterfaces);

    nInterfaces = 0;

    forAll(interfaces, i)
    {
        if (interfaces.set(i))
        {
            interfaces_.set
            (
                nInterfaces++,
                new procgpuLduInterface
                (
                    interfaces[i],
                    interfaceCoeffs[i]
                )
            );
        }
    }

}


Foam::procgpuLduMatrix::procgpuLduMatrix(Istream& is)
:
    upperAddr_(is),
    lowerAddr_(is),
    diag_(is),
    upper_(is),
    lower_(is),
    interfaces_(is)
{}


// * * * * * * * * * * * * * * * IOstream Operators  * * * * * * * * * * * * //

Foam::Ostream& Foam::operator<<(Ostream& os, const procgpuLduMatrix& cldum)
{
    os  << cldum.upperAddr_
        << cldum.lowerAddr_
        << cldum.diag_
        << cldum.upper_
        << cldum.lower_
        << cldum.interfaces_;

    return os;
}


// ************************************************************************* //
