/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2015 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "procgpuLduInterface.H"
#include "lduInterfacegpuField.H"
//#include "lduInterfaceField.H"
#include "cyclicgpuLduInterface.H"
#include "processorgpuLduInterface.H"

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

/*Foam::procgpuLduInterface::procgpuLduInterface
(
    const lduInterfaceField& interface,
    const scalarField& coeffs
)
:
    faceCells_(interface.interface().faceCells()),
    coeffs_(coeffs),
    myProcNo_(-1),
    neighbProcNo_(-1),
    tag_(-1),
    comm_(-1)
{
    if (isA<processorLduInterface>(interface.interface()))
    {
        const processorLduInterface& pldui =
            refCast<const processorLduInterface>(interface.interface());

        myProcNo_ = pldui.myProcNo();
        neighbProcNo_ = pldui.neighbProcNo();
        tag_ = pldui.tag();
        comm_ = pldui.comm();
    }
    else if (isA<cyclicLduInterface>(interface.interface()))
    {
    }
    else
    {
        FatalErrorInFunction
            << "Unknown lduInterface type "
            << interface.interface().type()
            << exit(FatalError);
    }
}*/

Foam::procgpuLduInterface::procgpuLduInterface
(
    const lduInterfacegpuField& interface,
    const scalargpuField& coeffs
)
:
    faceCells_(interface.interface().gpuFaceCells().size()),
    coeffs_(coeffs.size()),
    myProcNo_(-1),
    neighbProcNo_(-1),
    tag_(-1),
    comm_(-1)
{
    thrust::copy(interface.interface().gpuFaceCells().begin(),interface.interface().gpuFaceCells().end(),faceCells_.begin());
    thrust::copy(coeffs.begin(),coeffs.end(),coeffs_.begin());
    init(interface);
}

void Foam::procgpuLduInterface::init(const lduInterfacegpuField& interface)
{
    if (isA<processorgpuLduInterface>(interface.interface()))
    {
        const processorgpuLduInterface& pldui =
            refCast<const processorgpuLduInterface>(interface.interface());

        myProcNo_ = pldui.myProcNo();
        neighbProcNo_ = pldui.neighbProcNo();
        tag_ = pldui.tag();
        comm_ = pldui.comm();
    }
    else if (isA<cyclicgpuLduInterface>(interface.interface()))
    {
    }
    else
    {
        FatalErrorInFunction
            << "Unknown gpulduInterface type "
            << interface.interface().type()
            << exit(FatalError);
    }
}

Foam::procgpuLduInterface::procgpuLduInterface(Istream& is)
:
    faceCells_(is),
    coeffs_(is),
    myProcNo_(readLabel(is)),
    neighbProcNo_(readLabel(is)),
    tag_(readLabel(is)),
    comm_(readLabel(is))
{}


// * * * * * * * * * * * * * * * IOstream Operators  * * * * * * * * * * * * //

Foam::Ostream& Foam::operator<<(Ostream& os, const procgpuLduInterface& cldui)
{
    os  << cldui.faceCells_
        << cldui.coeffs_
        << cldui.myProcNo_
        << cldui.neighbProcNo_
        << cldui.tag_
        << cldui.comm_;

    return os;
}


// ************************************************************************* //
