/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
    Copyright (C) 2018-2019 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "GeometricScalargpuField.H"

#define TEMPLATE \
    template<class Type, template<class> class PatchField, class GeoMesh>
#include "GeometricgpuFieldFunctionsM.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * Global functions  * * * * * * * * * * * * * //

template<class Type, template<class> class PatchField, class GeoMesh>
void component
(
    GeometricgpuField
    <
        typename GeometricgpuField<Type, PatchField, GeoMesh>::cmptType,
        PatchField,
        GeoMesh
    >& gcf,
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf,
    const direction d
);

template<class Type, template<class> class PatchField, class GeoMesh>
void T
(
     GeometricgpuField<Type, PatchField, GeoMesh>& gf,
     const GeometricgpuField<Type, PatchField, GeoMesh>& gf1
);

template
<
    class Type,
    template<class> class PatchField,
    class GeoMesh,
    direction r
>
void pow
(
    GeometricgpuField<typename powProduct<Type, r>::type, PatchField, GeoMesh>& gf,
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf1
);

template
<
    class Type,
    template<class> class PatchField,
    class GeoMesh,
    direction r
>
tmp
<
    GeometricgpuField
    <typename powProduct<Type, r>::type, PatchField, GeoMesh>
>
pow
(
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf,
    typename powProduct<Type, r>::type
);

template
<
    class Type,
    template<class> class PatchField,
    class GeoMesh,
    direction r
>
tmp
<
    GeometricgpuField
    <typename powProduct<Type, r>::type, PatchField, GeoMesh>
>
pow
(
    const tmp<GeometricgpuField<Type, PatchField, GeoMesh>>& tgf,
    typename powProduct<Type, r>::type
);

template<class Type, template<class> class PatchField, class GeoMesh>
void sqr
(
    GeometricgpuField
    <typename outerProduct<Type, Type>::type, PatchField, GeoMesh>& gf,
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf1
);

template<class Type, template<class> class PatchField, class GeoMesh>
tmp
<
    GeometricgpuField
    <
        typename outerProduct<Type, Type>::type,
        PatchField,
        GeoMesh
    >
>
sqr(const GeometricgpuField<Type, PatchField, GeoMesh>& gf);

template<class Type, template<class> class PatchField, class GeoMesh>
tmp
<
    GeometricgpuField
    <
        typename outerProduct<Type, Type>::type,
        PatchField,
        GeoMesh
    >
>
sqr(const tmp<GeometricgpuField<Type, PatchField, GeoMesh>>& tgf);

template<class Type, template<class> class PatchField, class GeoMesh>
void magSqr
(
    GeometricgpuField<typename typeOfMag<Type>::type, PatchField, GeoMesh>& gsf,
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf
);

template<class Type, template<class> class PatchField, class GeoMesh>
tmp<GeometricgpuField<typename typeOfMag<Type>::type, PatchField, GeoMesh>>
magSqr
(
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf
);

template<class Type, template<class> class PatchField, class GeoMesh>
tmp<GeometricgpuField<typename typeOfMag<Type>::type, PatchField, GeoMesh>>
magSqr
(
    const tmp<GeometricgpuField<Type, PatchField, GeoMesh>>& tgf
);

template<class Type, template<class> class PatchField, class GeoMesh>
void mag
(
    GeometricgpuField<typename typeOfMag<Type>::type, PatchField, GeoMesh>& gsf,
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf
);

template<class Type, template<class> class PatchField, class GeoMesh>
tmp<GeometricgpuField<typename typeOfMag<Type>::type, PatchField, GeoMesh>>
mag
(
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf
);

template<class Type, template<class> class PatchField, class GeoMesh>
tmp<GeometricgpuField<typename typeOfMag<Type>::type, PatchField, GeoMesh>>
mag
(
    const tmp<GeometricgpuField<Type, PatchField, GeoMesh>>& tgf
);

template<class Type, template<class> class PatchField, class GeoMesh>
void cmptAv
(
    GeometricgpuField
    <
        typename GeometricgpuField<Type, PatchField, GeoMesh>::cmptType,
        PatchField,
        GeoMesh
    >& gcf,
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf
);

template<class Type, template<class> class PatchField, class GeoMesh>
tmp
<
    GeometricgpuField
    <
        typename GeometricgpuField<Type, PatchField, GeoMesh>::cmptType,
        PatchField,
        GeoMesh
    >
>
cmptAv(const GeometricgpuField<Type, PatchField, GeoMesh>& gf);

template<class Type, template<class> class PatchField, class GeoMesh>
tmp
<
    GeometricgpuField
    <
        typename GeometricgpuField<Type, PatchField, GeoMesh>::cmptType,
        PatchField,
        GeoMesh
    >
>
cmptAv(const tmp<GeometricgpuField<Type, PatchField, GeoMesh>>& tgf);


#define UNARY_REDUCTION_FUNCTION_WITH_BOUNDARY(returnType, func, binaryOp)     \
                                                                               \
template<class Type, template<class> class PatchField, class GeoMesh>          \
dimensioned<returnType> func                                                   \
(                                                                              \
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf                        \
);                                                                             \
                                                                               \
template<class Type, template<class> class PatchField, class GeoMesh>          \
dimensioned<returnType> func                                                   \
(                                                                              \
    const tmp<GeometricgpuField<Type, PatchField, GeoMesh>>& tgf1                 \
);

UNARY_REDUCTION_FUNCTION_WITH_BOUNDARY(Type, max, maxOp)
UNARY_REDUCTION_FUNCTION_WITH_BOUNDARY(Type, min, minOp)
UNARY_REDUCTION_FUNCTION_WITH_BOUNDARY(MinMax<Type>, minMax, minMaxOp)
UNARY_REDUCTION_FUNCTION_WITH_BOUNDARY(scalarMinMax, minMaxMag, minMaxMagOp)

#undef UNARY_REDUCTION_FUNCTION_WITH_BOUNDARY


#define UNARY_REDUCTION_FUNCTION(returnType, func, gFunc)                      \
                                                                               \
template<class Type, template<class> class PatchField, class GeoMesh>          \
dimensioned<returnType> func                                                   \
(                                                                              \
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf                        \
);                                                                             \
                                                                               \
template<class Type, template<class> class PatchField, class GeoMesh>          \
dimensioned<returnType> func                                                   \
(                                                                              \
    const tmp<GeometricgpuField<Type, PatchField, GeoMesh>>& tgf1                 \
);

UNARY_REDUCTION_FUNCTION(Type, sum, gSum)
UNARY_REDUCTION_FUNCTION(Type, average, gAverage)
UNARY_REDUCTION_FUNCTION(typename typeOfMag<Type>::type, sumMag, gSumMag)

#undef UNARY_REDUCTION_FUNCTION


BINARY_FUNCTION(Type, Type, Type, max)
BINARY_FUNCTION(Type, Type, Type, min)
BINARY_FUNCTION(Type, Type, Type, cmptMultiply)
BINARY_FUNCTION(Type, Type, Type, cmptDivide)

BINARY_TYPE_FUNCTION(Type, Type, Type, max)
BINARY_TYPE_FUNCTION(Type, Type, Type, min)
BINARY_TYPE_FUNCTION(Type, Type, Type, cmptMultiply)
BINARY_TYPE_FUNCTION(Type, Type, Type, cmptDivide)


// * * * * * * * * * * * * * * * Global operators  * * * * * * * * * * * * * //

UNARY_OPERATOR(Type, Type, -, negate, transform)

BINARY_OPERATOR(Type, Type, scalar, *, '*', multiply)
BINARY_OPERATOR(Type, scalar, Type, *, '*', multiply)
BINARY_OPERATOR(Type, Type, scalar, /, '|', divide)

BINARY_TYPE_OPERATOR_SF(Type, scalar, Type, *, '*', multiply)
BINARY_TYPE_OPERATOR_FS(Type, Type, scalar, *, '*', multiply)

BINARY_TYPE_OPERATOR_FS(Type, Type, scalar, /, '|', divide)


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#define PRODUCT_OPERATOR(product, op, opFunc)                                  \
                                                                               \
template                                                                       \
<class Type1, class Type2, template<class> class PatchField, class GeoMesh>    \
void opFunc                                                                    \
(                                                                              \
    GeometricgpuField                                                             \
    <typename product<Type1, Type2>::type, PatchField, GeoMesh>& gf,           \
    const GeometricgpuField<Type1, PatchField, GeoMesh>& gf1,                     \
    const GeometricgpuField<Type2, PatchField, GeoMesh>& gf2                      \
);                                                                             \
                                                                               \
template                                                                       \
<class Type1, class Type2, template<class> class PatchField, class GeoMesh>    \
tmp                                                                            \
<                                                                              \
    GeometricgpuField                                                             \
        <typename product<Type1, Type2>::type, PatchField, GeoMesh>            \
>                                                                              \
operator op                                                                    \
(                                                                              \
    const GeometricgpuField<Type1, PatchField, GeoMesh>& gf1,                     \
    const GeometricgpuField<Type2, PatchField, GeoMesh>& gf2                      \
);                                                                             \
                                                                               \
template                                                                       \
<class Type1, class Type2, template<class> class PatchField, class GeoMesh>    \
tmp                                                                            \
<                                                                              \
    GeometricgpuField                                                             \
    <typename product<Type1, Type2>::type, PatchField, GeoMesh>                \
>                                                                              \
operator op                                                                    \
(                                                                              \
    const GeometricgpuField<Type1, PatchField, GeoMesh>& gf1,                     \
    const tmp<GeometricgpuField<Type2, PatchField, GeoMesh>>& tgf2                \
);                                                                             \
                                                                               \
template                                                                       \
<class Type1, class Type2, template<class> class PatchField, class GeoMesh>    \
tmp                                                                            \
<                                                                              \
    GeometricgpuField                                                             \
    <typename product<Type1, Type2>::type, PatchField, GeoMesh>                \
>                                                                              \
operator op                                                                    \
(                                                                              \
    const tmp<GeometricgpuField<Type1, PatchField, GeoMesh>>& tgf1,               \
    const GeometricgpuField<Type2, PatchField, GeoMesh>& gf2                      \
);                                                                             \
                                                                               \
template                                                                       \
<class Type1, class Type2, template<class> class PatchField, class GeoMesh>    \
tmp                                                                            \
<                                                                              \
    GeometricgpuField                                                             \
    <typename product<Type1, Type2>::type, PatchField, GeoMesh>                \
>                                                                              \
operator op                                                                    \
(                                                                              \
    const tmp<GeometricgpuField<Type1, PatchField, GeoMesh>>& tgf1,               \
    const tmp<GeometricgpuField<Type2, PatchField, GeoMesh>>& tgf2                \
);                                                                             \
                                                                               \
template                                                                       \
<class Form, class Type, template<class> class PatchField, class GeoMesh>      \
void opFunc                                                                    \
(                                                                              \
    GeometricgpuField                                                             \
    <typename product<Type, Form>::type, PatchField, GeoMesh>& gf,             \
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf1,                      \
    const dimensioned<Form>& dvs                                               \
);                                                                             \
                                                                               \
template                                                                       \
<class Form, class Type, template<class> class PatchField, class GeoMesh>      \
tmp                                                                            \
<                                                                              \
    GeometricgpuField                                                             \
    <typename product<Type, Form>::type, PatchField, GeoMesh>                  \
>                                                                              \
operator op                                                                    \
(                                                                              \
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf1,                      \
    const dimensioned<Form>& dvs                                               \
);                                                                             \
                                                                               \
template                                                                       \
<                                                                              \
    class Form,                                                                \
    class Cmpt,                                                                \
    direction nCmpt,                                                           \
    class Type, template<class> class PatchField,                              \
    class GeoMesh                                                              \
>                                                                              \
tmp                                                                            \
<                                                                              \
    GeometricgpuField                                                             \
    <typename product<Form, Type>::type, PatchField, GeoMesh>                  \
>                                                                              \
operator op                                                                    \
(                                                                              \
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf1,                      \
    const VectorSpace<Form,Cmpt,nCmpt>& vs                                     \
);                                                                             \
                                                                               \
template                                                                       \
<class Form, class Type, template<class> class PatchField, class GeoMesh>      \
tmp                                                                            \
<                                                                              \
    GeometricgpuField                                                             \
    <typename product<Type, Form>::type, PatchField, GeoMesh>                  \
>                                                                              \
operator op                                                                    \
(                                                                              \
    const tmp<GeometricgpuField<Type, PatchField, GeoMesh>>& tgf1,                \
    const dimensioned<Form>& dvs                                               \
);                                                                             \
                                                                               \
template                                                                       \
<                                                                              \
    class Form,                                                                \
    class Cmpt,                                                                \
    direction nCmpt,                                                           \
    class Type, template<class> class PatchField,                              \
    class GeoMesh                                                              \
>                                                                              \
tmp                                                                            \
<                                                                              \
    GeometricgpuField                                                             \
    <typename product<Form, Type>::type, PatchField, GeoMesh>                  \
>                                                                              \
operator op                                                                    \
(                                                                              \
    const tmp<GeometricgpuField<Type, PatchField, GeoMesh>>& tgf1,                \
    const VectorSpace<Form,Cmpt,nCmpt>& vs                                     \
);                                                                             \
                                                                               \
template                                                                       \
<class Form, class Type, template<class> class PatchField, class GeoMesh>      \
void opFunc                                                                    \
(                                                                              \
    GeometricgpuField                                                             \
    <typename product<Form, Type>::type, PatchField, GeoMesh>& gf,             \
    const dimensioned<Form>& dvs,                                              \
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf1                       \
);                                                                             \
                                                                               \
template                                                                       \
<class Form, class Type, template<class> class PatchField, class GeoMesh>      \
tmp                                                                            \
<                                                                              \
    GeometricgpuField                                                             \
    <typename product<Form, Type>::type, PatchField, GeoMesh>                  \
>                                                                              \
operator op                                                                    \
(                                                                              \
    const dimensioned<Form>& dvs,                                              \
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf1                       \
);                                                                             \
                                                                               \
template                                                                       \
<                                                                              \
    class Form,                                                                \
    class Cmpt,                                                                \
    direction nCmpt,                                                           \
    class Type, template<class> class PatchField,                              \
    class GeoMesh                                                              \
>                                                                              \
tmp                                                                            \
<                                                                              \
    GeometricgpuField                                                             \
    <typename product<Form, Type>::type, PatchField, GeoMesh>                  \
>                                                                              \
operator op                                                                    \
(                                                                              \
    const VectorSpace<Form,Cmpt,nCmpt>& vs,                                    \
    const GeometricgpuField<Type, PatchField, GeoMesh>& gf1                       \
);                                                                             \
                                                                               \
template                                                                       \
<class Form, class Type, template<class> class PatchField, class GeoMesh>      \
tmp                                                                            \
<                                                                              \
    GeometricgpuField                                                             \
    <typename product<Form, Type>::type, PatchField, GeoMesh>                  \
>                                                                              \
operator op                                                                    \
(                                                                              \
    const dimensioned<Form>& dvs,                                              \
    const tmp<GeometricgpuField<Type, PatchField, GeoMesh>>& tgf1                 \
);                                                                             \
                                                                               \
template                                                                       \
<                                                                              \
    class Form,                                                                \
    class Cmpt,                                                                \
    direction nCmpt,                                                           \
    class Type, template<class> class PatchField,                              \
    class GeoMesh                                                              \
>                                                                              \
tmp                                                                            \
<                                                                              \
    GeometricgpuField                                                             \
    <typename product<Form, Type>::type, PatchField, GeoMesh>                  \
>                                                                              \
operator op                                                                    \
(                                                                              \
    const VectorSpace<Form,Cmpt,nCmpt>& vs,                                    \
    const tmp<GeometricgpuField<Type, PatchField, GeoMesh>>& tgf1                 \
);

PRODUCT_OPERATOR(typeOfSum, +, add)
PRODUCT_OPERATOR(typeOfSum, -, subtract)

PRODUCT_OPERATOR(outerProduct, *, outer)
PRODUCT_OPERATOR(crossProduct, ^, cross)
PRODUCT_OPERATOR(innerProduct, &, dot)
PRODUCT_OPERATOR(scalarProduct, &&, dotdot)

#undef PRODUCT_OPERATOR


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#include "undefFieldFunctionsM.H"

// ************************************************************************* //
