/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2013 OpenFOAM Foundation
    Copyright (C) 2019-2021 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "GeometricTensorgpuField.H"
#include "tensorFieldField.H"

#define TEMPLATE template<template<class> class PatchField, class GeoMesh>
#include "GeometricgpuFieldFunctionsM.C"

// * * * * * * * * * * * * * * * Global Functions  * * * * * * * * * * * * * //

template<class Cmpt, template<class> class PatchField, class GeoMesh>
void Foam::zip
(
    GeometricgpuField<Tensor<Cmpt>, PatchField, GeoMesh>& result,
    const GeometricgpuField<Cmpt, PatchField, GeoMesh>& xx,
    const GeometricgpuField<Cmpt, PatchField, GeoMesh>& xy,
    const GeometricgpuField<Cmpt, PatchField, GeoMesh>& xz,
    const GeometricgpuField<Cmpt, PatchField, GeoMesh>& yx,
    const GeometricgpuField<Cmpt, PatchField, GeoMesh>& yy,
    const GeometricgpuField<Cmpt, PatchField, GeoMesh>& yz,
    const GeometricgpuField<Cmpt, PatchField, GeoMesh>& zx,
    const GeometricgpuField<Cmpt, PatchField, GeoMesh>& zy,
    const GeometricgpuField<Cmpt, PatchField, GeoMesh>& zz
)
{
    Foam::zip
    (
        result.primitiveFieldRef(),
        xx.primitiveField(), xy.primitiveField(), xz.primitiveField(),
        yx.primitiveField(), yy.primitiveField(), yz.primitiveField(),
        zx.primitiveField(), zy.primitiveField(), zz.primitiveField()
    );

    Foam::zip
    (
        result.boundaryFieldRef(),
        xx.boundaryField(), xy.boundaryField(), xz.boundaryField(),
        yx.boundaryField(), yy.boundaryField(), yz.boundaryField(),
        zx.boundaryField(), zy.boundaryField(), zz.boundaryField()
    );
}


template<class Cmpt, template<class> class PatchField, class GeoMesh>
void Foam::unzip
(
    const GeometricgpuField<Tensor<Cmpt>, PatchField, GeoMesh>& input,
    GeometricgpuField<Cmpt, PatchField, GeoMesh>& xx,
    GeometricgpuField<Cmpt, PatchField, GeoMesh>& xy,
    GeometricgpuField<Cmpt, PatchField, GeoMesh>& xz,
    GeometricgpuField<Cmpt, PatchField, GeoMesh>& yx,
    GeometricgpuField<Cmpt, PatchField, GeoMesh>& yy,
    GeometricgpuField<Cmpt, PatchField, GeoMesh>& yz,
    GeometricgpuField<Cmpt, PatchField, GeoMesh>& zx,
    GeometricgpuField<Cmpt, PatchField, GeoMesh>& zy,
    GeometricgpuField<Cmpt, PatchField, GeoMesh>& zz
)
{
    Foam::unzip
    (
        input.primitiveField(),
        xx.primitiveFieldRef(), xy.primitiveFieldRef(), xz.primitiveFieldRef(),
        yx.primitiveFieldRef(), yy.primitiveFieldRef(), yz.primitiveFieldRef(),
        zx.primitiveFieldRef(), zy.primitiveFieldRef(), zz.primitiveFieldRef()
    );

    Foam::unzip
    (
        input.boundaryField(),
        xx.boundaryFieldRef(), xy.boundaryFieldRef(), xz.boundaryFieldRef(),
        yx.boundaryFieldRef(), yy.boundaryFieldRef(), yz.boundaryFieldRef(),
        zx.boundaryFieldRef(), zy.boundaryFieldRef(), zz.boundaryFieldRef()
    );
}


template<class Cmpt, template<class> class PatchField, class GeoMesh>
void Foam::zipRows
(
    GeometricgpuField<Tensor<Cmpt>, PatchField, GeoMesh>& result,
    const GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& x,
    const GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& y,
    const GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& z
)
{
    Foam::zipRows
    (
        result.primitiveFieldRef(),
        x.primitiveField(),
        y.primitiveField(),
        z.primitiveField()
    );

    Foam::zipRows
    (
        result.boundaryFieldRef(),
        x.boundaryField(),
        y.boundaryField(),
        z.boundaryField()
    );
}


template<class Cmpt, template<class> class PatchField, class GeoMesh>
void Foam::zipCols
(
    GeometricgpuField<Tensor<Cmpt>, PatchField, GeoMesh>& result,
    const GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& x,
    const GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& y,
    const GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& z
)
{
    Foam::zipCols
    (
        result.primitiveFieldRef(),
        x.primitiveField(),
        y.primitiveField(),
        z.primitiveField()
    );

    Foam::zipCols
    (
        result.boundaryFieldRef(),
        x.boundaryField(),
        y.boundaryField(),
        z.boundaryField()
    );
}


template<class Cmpt, template<class> class PatchField, class GeoMesh>
void Foam::unzipRows
(
    const GeometricgpuField<Tensor<Cmpt>, PatchField, GeoMesh>& input,
    GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& x,
    GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& y,
    GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& z
)
{
    Foam::unzipRows
    (
        input.primitiveField(),
        x.primitiveFieldRef(),
        y.primitiveFieldRef(),
        z.primitiveFieldRef()
    );

    Foam::unzipRows
    (
        input.boundaryField(),
        x.boundaryFieldRef(),
        y.boundaryFieldRef(),
        z.boundaryFieldRef()
    );
}


template<class Cmpt, template<class> class PatchField, class GeoMesh>
void Foam::unzipCols
(
    const GeometricgpuField<Tensor<Cmpt>, PatchField, GeoMesh>& input,
    GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& x,
    GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& y,
    GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& z
)
{
    Foam::unzipCols
    (
        input.primitiveField(),
        x.primitiveFieldRef(),
        y.primitiveFieldRef(),
        z.primitiveFieldRef()
    );

    Foam::unzipCols
    (
        input.boundaryField(),
        x.boundaryFieldRef(),
        y.boundaryFieldRef(),
        z.boundaryFieldRef()
    );
}


template<class Cmpt, template<class> class PatchField, class GeoMesh>
void Foam::unzipRow
(
    const GeometricgpuField<Tensor<Cmpt>, PatchField, GeoMesh>& input,
    const vector::components cmpt,
    GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& result
)
{
    Foam::unzipRow(input.primitiveField(), cmpt, result.primitiveFieldRef());

    Foam::unzipRow(input.boundaryField(), cmpt, result.boundaryFieldRef());
}


template<class Cmpt, template<class> class PatchField, class GeoMesh>
void Foam::unzipCol
(
    const GeometricgpuField<Tensor<Cmpt>, PatchField, GeoMesh>& input,
    const vector::components cmpt,
    GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& result
)
{
    Foam::unzipCol(input.primitiveField(), cmpt, result.primitiveFieldRef());

    Foam::unzipCol(input.boundaryField(), cmpt, result.boundaryFieldRef());
}


template<class Cmpt, template<class> class PatchField, class GeoMesh>
void Foam::unzipDiag
(
    const GeometricgpuField<Tensor<Cmpt>, PatchField, GeoMesh>& input,
    GeometricgpuField<Vector<Cmpt>, PatchField, GeoMesh>& result
)
{
    Foam::unzipDiag(input.primitiveField(), result.primitiveFieldRef());

    Foam::unzipDiag(input.boundaryField(), result.boundaryFieldRef());
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

UNARY_FUNCTION(tensor, tensor, T, transform)
UNARY_FUNCTION(scalar, tensor, tr, transform)
UNARY_FUNCTION(sphericalTensor, tensor, sph, transform)
UNARY_FUNCTION(symmTensor, tensor, symm, transform)
UNARY_FUNCTION(symmTensor, tensor, twoSymm, transform)
UNARY_FUNCTION(tensor, tensor, skew, transform)
UNARY_FUNCTION(tensor, tensor, dev, transform)
UNARY_FUNCTION(tensor, tensor, dev2, transform)
UNARY_FUNCTION(scalar, tensor, det, pow3)
UNARY_FUNCTION(tensor, tensor, cof, pow2)
UNARY_FUNCTION(tensor, tensor, inv, inv)

UNARY_FUNCTION(vector, symmTensor, eigenValues, transform)
UNARY_FUNCTION(tensor, symmTensor, eigenVectors, sign)


// * * * * * * * * * * * * * * * Global Operators  * * * * * * * * * * * * * //

UNARY_OPERATOR(vector, tensor, *, hdual, transform)
UNARY_OPERATOR(tensor, vector, *, hdual, transform)

BINARY_OPERATOR(vector, vector, tensor, /, '|', divide)
BINARY_TYPE_OPERATOR(vector, vector, tensor, /, '|', divide)


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#include "undefFieldFunctionsM.H"

// ************************************************************************* //
