/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2019 OpenFOAM Foundation
    Copyright (C) 2019-2020 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::nutkWallFunctionFvPatchScalarField

Group
    grpWallFunctions

Description
    This boundary condition provides a wall constraint on the turbulent
    viscosity, i.e. \c nut, based on the turbulent kinetic energy,
    i.e. \c k, for for low- and high-Reynolds number turbulence models.

Usage
    Example of the boundary condition specification:
    \verbatim
    <patchName>
    {
        // Mandatory entries (unmodifiable)
        type            nutkWallFunction;

        // Optional (inherited) entries
        ...
    }
    \endverbatim

    where the entries mean:
    \table
      Property  | Description                   | Type | Req'd  | Dflt
      type      | Type name: nutkWallFunction   | word | yes    | -
    \endtable

    The inherited entries are elaborated in:
      - \link nutWallFunctionFvPatchScalarField.H \endlink

Note
    - See \link nutWallFunctionFvPatchScalarField.H \endlink for the wall
    function blending treatments.

SourceFiles
    nutkWallFunctionFvPatchScalarField.C

\*---------------------------------------------------------------------------*/

#ifndef nutkWallFunctionFvPatchScalargpuField_H
#define nutkWallFunctionFvPatchScalargpuField_H

#include "nutWallFunctionFvPatchScalargpuField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
             Class nutkWallFunctionFvPatchScalarField Declaration
\*---------------------------------------------------------------------------*/

class nutkWallFunctionFvPatchScalargpuField
:
    public nutWallFunctionFvPatchScalargpuField
{
protected:

    // Protected Member Functions

        //- Calculate the turbulent viscosity
        virtual tmp<scalargpuField> calcNut() const;


public:

    //- Runtime type information
    TypeName("nutkWallFunction");


    // Constructors

        //- Construct from patch and internal field
        nutkWallFunctionFvPatchScalargpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&
        );

        //- Construct from patch, internal field and dictionary
        nutkWallFunctionFvPatchScalargpuField
        (
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&,
            const dictionary&
        );

        //- Construct by mapping given
        //- nutkWallFunctionFvPatchScalarField
        //- onto a new patch
        nutkWallFunctionFvPatchScalargpuField
        (
            const nutkWallFunctionFvPatchScalargpuField&,
            const gpufvPatch&,
            const DimensionedgpuField<scalar, gpuvolMesh>&,
            const fvPatchgpuFieldMapper&
        );

        //- Construct as copy
        nutkWallFunctionFvPatchScalargpuField
        (
            const nutkWallFunctionFvPatchScalargpuField&
        );

        //- Construct and return a clone
        virtual tmp<fvPatchScalargpuField> clone() const
        {
            return tmp<fvPatchScalargpuField>
            (
                new nutkWallFunctionFvPatchScalargpuField(*this)
            );
        }

        //- Construct as copy setting internal field reference
        nutkWallFunctionFvPatchScalargpuField
        (
            const nutkWallFunctionFvPatchScalargpuField&,
            const DimensionedgpuField<scalar, gpuvolMesh>&
        );

        //- Construct and return a clone setting internal field reference
        virtual tmp<fvPatchScalargpuField> clone
        (
            const DimensionedgpuField<scalar, gpuvolMesh>& iF
        ) const
        {
            return tmp<fvPatchScalargpuField>
            (
                new nutkWallFunctionFvPatchScalargpuField(*this, iF)
            );
        }


    // Member Functions

        //- Calculate and return the yPlus at the boundary
        virtual tmp<scalargpuField> yPlus() const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
