/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2011-2016 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::nonEquilibrium

Description
    Kinetic theory particle phase RAS model

    Reference:
    \verbatim
        "Derivation, implementation, and validation of computer simulation
         models for gas-solid fluidized beds",
        van Wachem, B.G.M.,
        Ph.D. Thesis, Delft University of Technology, Amsterdam, 2000.
    \endverbatim

    There are no default model coefficients.

SourceFiles
    nonEquilibrium.C

\*---------------------------------------------------------------------------*/

#ifndef nonEquilibrium_H
#define nonEquilibrium_H

#include "kineticTheoryModel.H"


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace kineticTheoryModels
{

/*---------------------------------------------------------------------------*\
                           Class nonEquilibrium Declaration
\*---------------------------------------------------------------------------*/

class nonEquilibrium
:
    public kineticTheoryModel
{
    // Protected data

        // Granular energy Prandtl number
        dimensionedScalar alphaTheta_;


public:

    //- Runtime type information
    TypeName("nonEquilibrium");


    // Constructors

        //- Construct from components
        nonEquilibrium
        (
            const dictionary& dict,
            const phaseModel& phase
        );


    //- Destructor
    virtual ~nonEquilibrium();


    // Member Functions

        //- Solve the kinetic theory equations
        virtual void solve
        (
            const volScalarField& beta,
            const volScalarField& alpha,
            const volTensorField& gradU,
            const volSymmTensorField D
        );
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace RASModels
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
