/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gpudfsolverLaplacianScheme.H"
#include "gpufvMesh.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

makeFvgpuLaplacianScheme(gpudfsolverLaplacianScheme)

#define declareFvmgpuLaplacianScalarGamma(Type)                                   \
                                                                               \
template<>                                                                     \
Foam::tmp<Foam::gpufvMatrix<Foam::Type>>                                          \
Foam::fv::gpudfsolverLaplacianScheme<Foam::Type, Foam::scalar>::fvmLaplacian         \
(                                                                              \
    const GeometricgpuField<scalar, fvsPatchgpuField, gpusurfaceMesh>& gamma,           \
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf                      \
)                                                                              \
{                                                                              \
    const gpufvMesh& mesh = this->mesh();                                         \
                                                                               \
    GeometricgpuField<scalar, fvsPatchgpuField, gpusurfaceMesh> gammaMagSf              \
    (                                                                          \
        gamma*mesh.magSf()                                                     \
    );                                                                         \
                                                                               \
    tmp<gpufvMatrix<Type>> tfvm = fvmLaplacianUncorrected                         \
    (                                                                          \
        gammaMagSf,                                                            \
        this->tsnGradScheme_().deltaCoeffs(vf),                                \
        vf                                                                     \
    );                                                                         \
    gpufvMatrix<Type>& fvm = tfvm.ref();                                          \
                                                                               \
    if (this->tsnGradScheme_().corrected())                                    \
    {                                                                          \
        if (mesh.hostmesh().fluxRequired(vf.name()))                                      \
        {                                                                      \
            fvm.faceFluxCorrectionPtr() = new                                  \
            GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>                   \
            (                                                                  \
                gammaMagSf*this->tsnGradScheme_().correction(vf)               \
            );                                                                 \
                                                                               \
            fvm.source() -=                                                    \
                mesh.V()*                                                      \
                fvc::div                                                       \
                (                                                              \
                    *fvm.faceFluxCorrectionPtr()                               \
                )().primitiveField();                                          \
        }                                                                      \
        else                                                                   \
        {                                                                      \
            fvm.source() -=                                                    \
                mesh.V()*                                                      \
                fvc::div                                                       \
                (                                                              \
                    gammaMagSf*this->tsnGradScheme_().correction(vf)           \
                )().primitiveField();                                          \
        }                                                                      \
    }                                                                          \
                                                                               \
    return tfvm;                                                               \
}                                                                              \
                                                                               \
                                                                               \
template<>                                                                     \
Foam::tmp<Foam::GeometricgpuField<Foam::Type, Foam::fvPatchgpuField, Foam::gpuvolMesh>> \
Foam::fv::gpudfsolverLaplacianScheme<Foam::Type, Foam::scalar>::fvcLaplacian         \
(                                                                              \
    const GeometricgpuField<scalar, fvsPatchgpuField, gpusurfaceMesh>& gamma,           \
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf                      \
)                                                                              \
{                                                                              \
    const gpufvMesh& mesh = this->mesh();                                         \
                                                                               \
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> tLaplacian                \
    (                                                                          \
        fvc::div(gamma*this->tsnGradScheme_().snGrad(vf)*mesh.magSf())         \
    );                                                                         \
                                                                               \
    tLaplacian.ref().rename                                                    \
    (                                                                          \
        "laplacian(" + gamma.name() + ',' + vf.name() + ')'                    \
    );                                                                         \
                                                                               \
    return tLaplacian;                                                         \
}


declareFvmgpuLaplacianScalarGamma(scalar);
declareFvmgpuLaplacianScalarGamma(vector);
declareFvmgpuLaplacianScalarGamma(sphericalTensor);
declareFvmgpuLaplacianScalarGamma(symmTensor);
declareFvmgpuLaplacianScalarGamma(tensor);


// ************************************************************************* //
