/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

InNamespace
    Foam::fvm

Description
    Calculate the matrix for the laplacian of the field.

SourceFiles
    fvmLaplacian.C

\*---------------------------------------------------------------------------*/

#ifndef gpufvmLaplacian_H
#define gpufvmLaplacian_H

#include "volgpuFieldsFwd.H"
#include "surfacegpuFieldsFwd.H"
#include "gpufvMatrix.H"
#include "zero.H"
#include "one.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                     Namespace fvm functions Declaration
\*---------------------------------------------------------------------------*/

namespace fvm
{
    template<class Type>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word&
    );

    template<class Type>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );


    template<class Type>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const zero&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word&
    );

    template<class Type>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const zero&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );


    template<class Type>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const one&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word&
    );

    template<class Type>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const one&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );


    template<class Type, class GType>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const dimensioned<GType>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word&
    );

    template<class Type, class GType>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const dimensioned<GType>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );


    template<class Type, class GType>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word&
    );

    template<class Type, class GType>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );


    template<class Type, class GType>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const tmp<GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word&
    );

    template<class Type, class GType>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const tmp<GeometricgpuField<GType, fvPatchgpuField, gpuvolMesh>>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );


    template<class Type, class GType>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word&
    );

    template<class Type, class GType>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const tmp<GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const word&
    );

    template<class Type, class GType>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );

    template<class Type, class GType>
    tmp<gpufvMatrix<Type>> laplacian
    (
        const tmp<GeometricgpuField<GType, fvsPatchgpuField, gpusurfaceMesh>>&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "gpufvmLaplacian.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
