/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "volgpuFields.H"
#include "surfacegpuFields.H"
#include "gpufvMatrix.H"
#include "gpuddtScheme.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace fvm
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type>
tmp<gpufvMatrix<Type>>
ddt
(
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return fv::gpuddtScheme<Type>::New
    (
        vf.mesh(),
        vf.mesh().hostmesh().ddtScheme("ddt(" + vf.name() + ')')
    ).ref().fvmDdt(vf);
}


template<class Type>
tmp<gpufvMatrix<Type>>
ddt
(
    const one&,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return ddt(vf);
}


template<class Type>
tmp<gpufvMatrix<Type>>
ddt
(
    const dimensionedScalar& rho,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return fv::gpuddtScheme<Type>::New
    (
        vf.mesh(),
        vf.mesh().hostmesh().ddtScheme("ddt(" + rho.name() + ',' + vf.name() + ')')
    ).ref().fvmDdt(rho, vf);
}


template<class Type>
tmp<gpufvMatrix<Type>>
ddt
(
    const volScalargpuField& rho,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return fv::gpuddtScheme<Type>::New
    (
        vf.mesh(),
        vf.mesh().hostmesh().ddtScheme("ddt(" + rho.name() + ',' + vf.name() + ')')
    ).ref().fvmDdt(rho, vf);
}


template<class Type>
tmp<gpufvMatrix<Type>>
ddt
(
    const volScalargpuField& alpha,
    const volScalargpuField& rho,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return fv::gpuddtScheme<Type>::New
    (
        vf.mesh(),
        vf.mesh().hostmesh().ddtScheme
        (
            "ddt("
          + alpha.name() + ','
          + rho.name() + ','
          + vf.name() + ')'
        )
    ).ref().fvmDdt(alpha, rho, vf);
}


template<class Type>
tmp<gpufvMatrix<Type>>
ddt
(
    const one&,
    const one&,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return ddt(vf);
}


template<class Type>
tmp<gpufvMatrix<Type>>
ddt
(
    const one&,
    const volScalargpuField& rho,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return ddt(rho, vf);
}


template<class Type>
tmp<gpufvMatrix<Type>>
ddt
(
    const volScalargpuField& alpha,
    const one&,
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return ddt(alpha, vf);
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fvm

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// ************************************************************************* //
