/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2016 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "gpufvcGrad.H"
#include "gpufvcSurfaceIntegrate.H"
#include "gpufvMesh.H"
#include "gpugaussGrad.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace fvc
{

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

template<class Type>
tmp
<
    GeometricField
    <
        typename outerProduct<vector, Type>::type, fvPatchgpuField, gpuvolMesh
    >
>
grad
(
    const GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>& ssf
)
{
    return fv::gpugaussGrad<Type>::gradf(ssf, "grad(" + ssf.name() + ')');
}


template<class Type>
tmp
<
    GeometricgpuField
    <
        typename outerProduct<vector,Type>::type, fvPatchgpuField, gpuvolMesh
    >
>
grad
(
    const tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>>& tssf
)
{
    typedef typename outerProduct<vector, Type>::type GradType;
    tmp<GeometricgpuField<GradType, fvPatchgpuField, gpuvolMesh>> Grad
    (
        fvc::grad(tssf())
    );
    tssf.clear();
    return Grad;
}


template<class Type>
tmp
<
    GeometricgpuField
    <
        typename outerProduct<vector,Type>::type, fvPatchgpuField, gpuvolMesh
    >
>
grad
(
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf,
    const word& name
)
{
    return fv::gpugradScheme<Type>::New
    (
        vf.mesh(),
        vf.mesh().hostmesh().gradScheme(name)
    )().grad(vf, name);
}


template<class Type>
tmp
<
    GeometricgpuField
    <
        typename outerProduct<vector,Type>::type, fvPatchgpuField, gpuvolMesh
    >
>
grad
(
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf,
    const word& name
)
{
    tmp
    <
        GeometricgpuField
        <
            typename outerProduct<vector, Type>::type, fvPatchgpuField, gpuvolMesh
        >
    > tGrad
    (
        fvc::grad(tvf(), name)
    );
    tvf.clear();
    return tGrad;
}


template<class Type>
tmp
<
    GeometricgpuField
    <
        typename outerProduct<vector,Type>::type, fvPatchgpuField, gpuvolMesh
    >
>
grad
(
    const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& vf
)
{
    return fvc::grad(vf, "grad(" + vf.name() + ')');
}


template<class Type>
tmp
<
    GeometricgpuField
    <
        typename outerProduct<vector,Type>::type, fvPatchgpuField, gpuvolMesh
    >
>
grad
(
    const tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>>& tvf
)
{
    typedef typename outerProduct<vector, Type>::type GradType;
    tmp<GeometricgpuField<GradType, fvPatchgpuField, gpuvolMesh>> Grad
    (
        fvc::grad(tvf())
    );
    tvf.clear();
    return Grad;
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace fvc

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// ************************************************************************* //
