/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2017 OpenFOAM Foundation
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

InNamespace
    Foam::fvc

Description
    Calculate the first temporal derivative.

SourceFiles
    fvcDdt.C

\*---------------------------------------------------------------------------*/


#ifndef gpufvcDdt_H
#define gpufvcDdt_H

#include "volgpuFieldsFwd.H"
#include "surfacegpuFieldsFwd.H"
#include "dimensionedTypes.H"
#include "one.H"
#include "geometricZeroField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                     Namespace fvc functions Declaration
\*---------------------------------------------------------------------------*/

namespace fvc
{
    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> ddt
    (
        const dimensioned<Type>,
        const gpufvMesh&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> ddt
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> ddt
    (
        const dimensionedScalar&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> ddt
    (
        const volScalargpuField&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> ddt
    (
        const volScalargpuField&,
        const volScalargpuField&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>> ddt
    (
        const GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> ddt
    (
        const one&,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&
    );

    template<class Type>
    tmp<GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>> ddt
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>&,
        const one&
    );

    template<class Type>
    tmp
    <
        GeometricgpuField
        <
            typename Foam::flux<Type>::type,
            fvsPatchgpuField,
            gpusurfaceMesh
        >
    >
    ddtCorr
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& U,
        const GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>& Uf
    );

    template<class Type>
    tmp
    <
        GeometricgpuField
        <
            typename Foam::flux<Type>::type,
            fvsPatchgpuField,
            gpusurfaceMesh
        >
    >
    ddtCorr
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& U,
        const GeometricgpuField
        <
            typename Foam::flux<Type>::type,
            fvsPatchgpuField,
            gpusurfaceMesh
        >& phi
    );

    template<class Type>
    tmp
    <
        GeometricgpuField
        <
            typename Foam::flux<Type>::type,
            fvsPatchgpuField,
            gpusurfaceMesh
        >
    >
    ddtCorr
    (
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& U,
        const GeometricgpuField
        <
            typename Foam::flux<Type>::type,
            fvsPatchgpuField,
            gpusurfaceMesh
        >& phi,
        const autoPtr<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>>& Uf
    );

    template<class Type>
    tmp
    <
        GeometricgpuField
        <
            typename Foam::flux<Type>::type,
            fvsPatchgpuField,
            gpusurfaceMesh
        >
    >
    ddtCorr
    (
        const volScalargpuField& rho,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& U,
        const GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>& Uf
    );

    template<class Type>
    tmp
    <
        GeometricgpuField
        <
            typename Foam::flux<Type>::type,
            fvsPatchgpuField,
            gpusurfaceMesh
        >
    >
    ddtCorr
    (
        const volScalargpuField& rho,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& U,
        const GeometricgpuField
        <
            typename Foam::flux<Type>::type,
            fvsPatchgpuField,
            gpusurfaceMesh
        >& phi
    );

    template<class Type>
    tmp
    <
        GeometricgpuField
        <
            typename Foam::flux<Type>::type,
            fvsPatchgpuField,
            gpusurfaceMesh
        >
    >
    ddtCorr
    (
        const volScalargpuField& rho,
        const GeometricgpuField<Type, fvPatchgpuField, gpuvolMesh>& U,
        const GeometricgpuField
        <
            typename Foam::flux<Type>::type,
            fvsPatchgpuField,
            gpusurfaceMesh
        >& phi,
        const autoPtr<GeometricgpuField<Type, fvsPatchgpuField, gpusurfaceMesh>>& Uf
    );
}


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#ifdef NoRepository
    #include "gpufvcDdt.C"
#endif

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************************************************************* //
