/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 2011-2013 OpenFOAM Foundation
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/
#define TEMPLATE template<class Type>
#include "gpuFieldFunctionsM.H"
#include "UPstream.H"
#include "Pstream.H"

namespace Foam
{
TEMPLATE
void component
(
    gpuField<typename gpuField<Type>::cmptType>& res,
    const gpuList<Type>& f,
    const direction d
);


TEMPLATE
void T(gpuField<Type>& res, const gpuList<Type>& f);

template<class Type, int r>
void pow
(
    gpuField<typename powProduct<Type, r>::type>& res,
    const gpuList<Type>& vf
);


template<class Type, int r>
tmp<gpuField<typename powProduct<Type, r>::type> >
pow
(
    const gpuList<Type>& f,
    typename powProduct<Type, r>::type
      = pTraits<typename powProduct<Type, r>::type>::zero
);

template<class Type, int r>
tmp<gpuField<typename powProduct<Type, r>::type> >
pow
(
    const tmp<gpuField<Type> >& tf,
    typename powProduct<Type, r>::type
      = pTraits<typename powProduct<Type, r>::type>::zero
);

TEMPLATE
void magSqr(gpuField<typename typeOfMag<Type>::type>& res, const gpuList<Type>& f);

TEMPLATE
tmp<gpuField<typename typeOfMag<Type>::type> > magSqr(const gpuList<Type>& f);

TEMPLATE
tmp<gpuField<typename typeOfMag<Type>::type> > magSqr(const tmp<gpuField<Type> >& tf);

TEMPLATE
void mag(gpuField<typename typeOfMag<Type>::type>& res, const gpuList<Type>& f);

TEMPLATE
tmp<gpuField<typename typeOfMag<Type>::type> > mag(const gpuList<Type>& f);

TEMPLATE
tmp<gpuField<typename typeOfMag<Type>::type> > mag(const tmp<gpuField<Type> >& tf);

TEMPLATE
void cmptMax(gpuField<typename gpuField<Type>::cmptType>& res, const gpuList<Type>& f);

TEMPLATE
tmp<gpuField<typename gpuField<Type>::cmptType> > cmptMax(const gpuList<Type>& f);

TEMPLATE
tmp<gpuField<typename gpuField<Type>::cmptType> >
cmptMax(const tmp<gpuField<Type> >& tf);


TEMPLATE
void cmptMin(gpuField<typename gpuField<Type>::cmptType>& res, const gpuList<Type>& f);

TEMPLATE
tmp<gpuField<typename gpuField<Type>::cmptType> > cmptMin(const gpuList<Type>& f);

TEMPLATE
tmp<gpuField<typename gpuField<Type>::cmptType> >
cmptMin(const tmp<gpuField<Type> >& tf);


TEMPLATE
void cmptAv(gpuField<typename gpuField<Type>::cmptType>& res, const gpuList<Type>& f);

TEMPLATE
tmp<gpuField<typename gpuField<Type>::cmptType> > cmptAv(const gpuList<Type>& f);

TEMPLATE
tmp<gpuField<typename gpuField<Type>::cmptType> > cmptAv(const tmp<gpuField<Type> >& tf);


TEMPLATE
void cmptMag(gpuField<Type>& res, const gpuList<Type>& f);

TEMPLATE
tmp<gpuField<Type> > cmptMag(const gpuList<Type>& f);

TEMPLATE
tmp<gpuField<Type> > cmptMag(const tmp<gpuField<Type> >& tf);

#define TMP_UNARY_FUNCTION(ReturnType, Func)                                  \
                                                                              \
TEMPLATE                                                                      \
ReturnType Func(const tmp<gpuField<Type> >& tf1);

TEMPLATE
Type max(const gpuList<Type>& f);

TMP_UNARY_FUNCTION(Type, max)

TEMPLATE
Type min(const gpuList<Type>& f);

TMP_UNARY_FUNCTION(Type, min)

TEMPLATE
Type sum(const gpuList<Type>& f);

TMP_UNARY_FUNCTION(Type, sum)

TEMPLATE
Type maxMagSqr(const gpuList<Type>& f);

TMP_UNARY_FUNCTION(Type, maxMagSqr)

TEMPLATE
Type minMagSqr(const gpuList<Type>& f);

TMP_UNARY_FUNCTION(Type, minMagSqr)


TEMPLATE
typename scalarProduct<Type, Type>::type
sumProd(const gpuList<Type>& f1, const gpuList<Type>& f2);

TEMPLATE
Type sumCmptProd(const gpuList<Type>& f1, const gpuList<Type>& f2);

//#ifndef NO_SQR
TEMPLATE
typename outerProduct1<Type>::type
sumSqr(const gpuList<Type>& f);

TMP_UNARY_FUNCTION(typename outerProduct1<Type>::type, sumSqr)
//#endif

TEMPLATE
typename typeOfMag<Type>::type
sumMag(const gpuList<Type>& f);

TMP_UNARY_FUNCTION(typename typeOfMag<Type>::type, sumMag)

TEMPLATE
Type sumCmptMag(const gpuList<Type>& f);

TMP_UNARY_FUNCTION(Type, sumCmptMag)

TEMPLATE
Type average(const gpuList<Type>& f);

TMP_UNARY_FUNCTION(Type, average)

#define G_UNARY_FUNCTION(ReturnType, gFunc, Func, rFunc)                         \
																				 \
template<class Type>                                                             \
ReturnType gFunc(const gpuList<Type>& f, const label comm = UPstream::worldComm); \
TMP_UNARY_FUNCTION(ReturnType, gFunc)

G_UNARY_FUNCTION(Type, gMax, max, max)
G_UNARY_FUNCTION(Type, gMin, min, min)
G_UNARY_FUNCTION(Type, gSum, sum, sum)
G_UNARY_FUNCTION(Type, gMaxMagSqr, maxMagSqr, maxMagSqr)
G_UNARY_FUNCTION(Type, gMinMagSqr, minMagSqr, minMagSqr)
//#ifndef NO_SQR
G_UNARY_FUNCTION(typename outerProduct1<Type>::type, gSumSqr, sumSqr, sum)
//#endif
G_UNARY_FUNCTION(typename typeOfMag<Type>::type, gSumMag, sumMag, sum)
G_UNARY_FUNCTION(Type, gSumCmptMag, sumCmptMag, sum)

#undef G_UNARY_FUNCTION

TEMPLATE
typename scalarProduct<Type, Type>::type gSumProd
(
    const gpuList<Type>& f1,
    const gpuList<Type>& f2,
    const label comm = UPstream::worldComm
);

TEMPLATE
Type gSumCmptProd
(
    const gpuList<Type>& f1,
    const gpuList<Type>& f2,
    const label comm = UPstream::worldComm
);

TEMPLATE
Type gAverage
(
    const gpuList<Type>& f,
    const label comm = UPstream::worldComm
);

TMP_UNARY_FUNCTION(Type, gAverage)

#undef TMP_UNARY_FUNCTION

BINARY_FUNCTION(Type, Type, Type, max)
BINARY_FUNCTION(Type, Type, Type, min)
BINARY_FUNCTION(Type, Type, Type, cmptMultiply)
BINARY_FUNCTION(Type, Type, Type, cmptDivide)

BINARY_TYPE_FUNCTION(Type, Type, Type, max)
BINARY_TYPE_FUNCTION(Type, Type, Type, min)
BINARY_TYPE_FUNCTION(Type, Type, Type, cmptMultiply)
BINARY_TYPE_FUNCTION(Type, Type, Type, cmptDivide)


// * * * * * * * * * * * * * * * Global operators  * * * * * * * * * * * * * //

UNARY_OPERATOR(Type, Type, -, negate)
BINARY_OPERATOR(Type, Type, scalar, *, multiply)
BINARY_OPERATOR(Type, scalar, Type, *, multiply)
BINARY_OPERATOR(Type, Type, scalar, /, divide)

BINARY_TYPE_OPERATOR_SF(Type, scalar, Type, *, multiply)
BINARY_TYPE_OPERATOR_FS(Type, Type, scalar, *, multiply)

BINARY_TYPE_OPERATOR_FS(Type, Type, scalar, /, divide)

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

}// End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#include "undefgpuFieldFunctionsM.H"
#include "scalarField.H"

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //
