#!/bin/bash
set -ex

echo FFMPEG_ROOT=${FFMPEG_ROOT}

script_dir="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
. "$script_dir/pkg_helpers.bash"

export BUILD_TYPE="wheel"
setup_env 0.12.0
setup_wheel_python
pip_install numpy future cmake ninja
setup_pip_pytorch_version
python setup.py clean
if [[ "$OSTYPE" == "msys" ]]; then
    python_tag="$(echo "cp$PYTHON_VERSION" | tr -d '.')"
    "$script_dir/vc_env_helper.bat" python setup.py bdist_wheel --plat-name win_amd64 --python-tag $python_tag
else
    python setup.py bdist_wheel
fi
