# TORCHAUDIO

## 介绍

[Introduction](README_ORIGIN.md)

## 安装

### System Requirements

- Linux.

- Python 3.7, 3.8, 3.9

- (**推荐**) Upgrade pip

  ```
  python3 -m pip install --upgrade pip #--user
  ```

### 使用pip安装（以0.13.1版本为例）
可以在光合[光合开发者社区](https://developer.hpccube.com/tool/#sdk) AI 生态包中获取最新的 torchaudio Release 版本（需对应 DCU Toolkit 版本与 python 版本）
```bash
python3 -m pip install torchaudio-0.13.1+gitd946a7c.abi0.dtk2304-cp37-cp37m-linux_x86_64.whl
```

### 使用源码安装

#### 编译环境准备（以0.13.1版本为例）

- 拉取 torchaudio 代码

  ```
  git clone -b 0.13.1-dtk23.04 http://developer.hpccube.com/codes/aicomponent/torchaudio.git
  ```

- 在[开发者社区](https://developer.hpccube.com/tool/#sdk) DCU Toolkit 中下载 DTK-23.04 解压至 /opt/ 路径下，并建立软链接

  ```
  cd /opt && ln -s dtk-23.04 dtk
  ```

- 在光合[光合开发者社区](https://developer.hpccube.com/tool/#sdk) AI 生态包中获取对应的 pytorch Release 版本（需对应 DCU Toolkit 版本与 python 版本）
```bash
python3 -m pip install torch-1.13.1a0+git4c8a1fe.abi0.dtk2304-cp37-cp37m-linux_x86_64.whl
```

- 导入环境变量以及安装必要依赖库

  ```bash
  source /opt/dtk/env.sh

  export PYTORCH_ROCM_ARCH="gfx906;gfx926"

  MAX_JOBS=16
  pip3 install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple --trusted-host pypi.tuna.tsinghua.edu.cn
  ```


#### 编译安装

- 执行编译命令
  ```shell
  cd audio
  CXX=hipcc CC=hipcc python3 setup.py bdist_wheel
  pip install dist/torchaudio*
  ```

