


# Custom Op ONNXRuntime

## Purpose

`Adding the custom operator implementation and registering it in ONNX Runtime`

## 环境配置

### Docker（方法一）

拉取镜像：

```plaintext
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:2.4.1-ubuntu22.04-dtk25.04-py3.10-fixpy-onnx1.19.2
```

创建并启动容器：

```plaintext
docker run --shm-size 16g --network=host --name=test --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/customop_onnxruntime:/home/customop -it <Your Image ID> /bin/bash
```

### Dockerfile（方法二）

```
cd ./docker
docker build --no-cache -t customop:test .

docker run --shm-size 16g --network=host --name=video_ort --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/customop_onnxruntime:/home/customop -it <Your Image ID> /bin/bash
```

## 使用

### 编译工程

```
git clone http://developer.sourcefind.cn/codes/modelzoo/customop_onnxruntime.git
cd customop_onnxruntime
python model.py     // 生成模型(model换成自己算子的模型)
bash compile.sh     // 编译生成算子库
```

### 运行示例

1. 目录

```
rocm_custom_op
├── compile.sh              // 编译脚本
├── custom_op_library.cc    // 注册自定义算子
├── custom_op_library.h
├── docker
├── include
├── model.py               // 创建自定义模型（需要改名）
├── readme.md
├── rocm_ops.cc             // 调用自定义算子
├── rocm_ops.h
├── rocm_ops.hip            // 自定义算子实现
└── benchmark.py                // 测试算子
```

2. 执行步骤

```
python test.py      // 测试模型     
```

3. 备注

```
1.在model.py中，定义了一个add.onnx模型。如需重新定义模型，请修改该文件。
2.在compile.sh中，选项--offload-arch=gfx928，请将gfx928替换为本机适配的rocm架构(可用rocminfo | grep gfx查看)。
3.若需测试别的自定义算子，修改内容如下：
    3.1 修改rocm_ops.hip，重新实现自定义算子
    3.2 修改rocm_ops.cc, 修改对自定义算子的调用
    3.3 修改model.py，修改自定义模型的创建
    3.4 修改benchmark.py，修改运行模型的输入数据
```

## result

无

### 精度

无

## 应用场景

### 功能

添加ORT custom op

## 源码仓库及问题反馈

- http://developer.sourcefind.cn/codes/modelzoo/customop_onnxruntime.git

## 参考资料

- https://github.com/microsoft/onnxruntime
- https://onnxruntime.ai/docs/extensions/add-op.html
