#include "yaml-cpp/node/emit.h"
#include "yaml-cpp/emitfromevents.h"
#include "yaml-cpp/emitter.h"
#include "nodeevents.h"

namespace YAML
{
	Emitter& operator << (Emitter& out, const Node& node)
	{
		EmitFromEvents emitFromEvents(out);
		NodeEvents events(node);
		events.Emit(emitFromEvents);
		return out;
	}
	
	std::ostream& operator << (std::ostream& out, const Node& node)
	{
		Emitter emitter;
		emitter << node;
		out << emitter.c_str();
		return out;
	}
}
