/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2022 Advanced Micro Devices, Inc. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "verify_program.hpp"
#include <migraphx/program.hpp>
#include <migraphx/generate.hpp>
#include <migraphx/make_op.hpp>

struct test_fuse_ck : verify_program<test_fuse_ck>
{
    migraphx::program create_program() const
    {
        migraphx::program p;
        auto* mm = p.get_main_module();
        unsigned long m = 256; 
        unsigned long k = m;
        unsigned long n = k;
        migraphx::shape m1_shape{migraphx::shape::half_type, {m, k}};
        migraphx::shape m2_shape{migraphx::shape::half_type, {k, n}};
        migraphx::shape m3_shape{migraphx::shape::half_type, {m, n}};
        auto l1 = mm->add_parameter("1", m1_shape);
        auto l2 = mm->add_parameter("2", m2_shape);
        auto l3 = mm->add_parameter("3", m3_shape);
        auto l4 = mm->add_parameter("4", m3_shape);

        auto gemm = mm->add_instruction(migraphx::make_op("dot"), l1, l2);
        auto add = mm->add_instruction(migraphx::make_op("add"), gemm, l3);
        auto x = mm->add_instruction(migraphx::make_op("add"), add, l4);

        std::vector<size_t> input_lens{m, n};
        migraphx::shape m4_shape{migraphx::shape::half_type, {1}};
        auto half        = mm->add_literal(migraphx::literal{m4_shape, {0.5}});
        auto one         = mm->add_literal(migraphx::literal{m4_shape, {1.0}});
        auto sqrt2       = mm->add_literal(migraphx::literal{m4_shape, {M_SQRT2}});
        auto half_mbcast = mm->add_instruction(
            migraphx::make_op("multibroadcast", {{"out_lens", input_lens}}), half);
        auto mul_half     = mm->add_instruction(migraphx::make_op("mul"), x, half_mbcast);
        auto sqrt2_mbcast = mm->add_instruction(
            migraphx::make_op("multibroadcast", {{"out_lens", input_lens}}), sqrt2);
        auto div        = mm->add_instruction(migraphx::make_op("div"), x, sqrt2_mbcast);
        auto erf        = mm->add_instruction(migraphx::make_op("erf"), div);
        auto one_mbcast = mm->add_instruction(
            migraphx::make_op("multibroadcast", {{"out_lens", input_lens}}), one);
        auto add_one = mm->add_instruction(migraphx::make_op("add"), erf, one_mbcast);
        mm->add_instruction(migraphx::make_op("mul"), mul_half, add_one);

        return p;
    }
};
