
#include "verify_program.hpp"
#include <migraphx/program.hpp>
#include <migraphx/generate.hpp>
#include <migraphx/operators.hpp>

struct test_add_gelu : verify_program<test_add_gelu>
{
    migraphx::program create_program() const
    {
        migraphx::program p;
        auto* mm = p.get_main_module();
        std::vector<size_t> input_lens{1, 1, 5};
        auto x            = mm->add_parameter("x", {migraphx::shape::float_type, input_lens});
        auto y            = mm->add_parameter("y", {migraphx::shape::float_type, input_lens});
        auto half         = mm->add_literal(0.5f);
        auto one          = mm->add_literal(1.0f);
        auto sqrt2        = mm->add_literal(static_cast<float>(M_SQRT2));
        auto add          = mm->add_instruction(migraphx::op::add{}, x, y);
        auto half_mbcast  = mm->add_instruction(migraphx::op::multibroadcast{input_lens}, half);
        auto mul_half     = mm->add_instruction(migraphx::op::mul{}, add, half_mbcast);
        auto sqrt2_mbcast = mm->add_instruction(migraphx::op::multibroadcast{input_lens}, sqrt2);
        auto div          = mm->add_instruction(migraphx::op::div{}, add, sqrt2_mbcast);
        auto erf          = mm->add_instruction(migraphx::op::erf{}, div);
        auto one_mbcast   = mm->add_instruction(migraphx::op::multibroadcast{input_lens}, one);
        auto add_one      = mm->add_instruction(migraphx::op::add{}, erf, one_mbcast);
        mm->add_instruction(migraphx::op::mul{}, mul_half, add_one);
        return p;
    }
};
