# REMINDER: this code needs to be rewritten for the new framework. Remove this comment when the code is fully converted.

from lm_eval.base import Dataset
from lm_eval.utils import sh
import json
import requests
import ftfy


class Lambada(Dataset):
    def __init__(self):
        self.download()
    def download(self):
        sh("mkdir -p data/lambada")
        with open("data/lambada/lambada_test.json", 'w') as f:
            req = requests.get("https://storage.googleapis.com/gpt-2/data/lambada_test.jsonl")
            req.raise_for_status()
            jsons = [json.loads(l) for l in req.iter_lines()]
            texts = [ftfy.fix_text(j['text'], normalization='NFKC') for j in jsons]
            json.dump(texts, f)

    def has_training_docs(self):
        return False

    def has_validation_docs(self):
        return False

    def has_test_docs(self):
        return True

    def training_docs(self):
        pass

    def validation_docs(self):
        pass

    def load_doc(self, myjson):
        return [doc for doc in myjson]

    def test_docs(self):
        myjson = json.load(open("data/lambada/lambada_test.json"))
        return self.load_doc(myjson)

    def doc_to_text(self, doc, include_target=True):
        # TODO: implement.
    
    def fewshot_description(self):
        # TODO: figure out description
        return ""

    def construct_requests(self, doc, ctx):
        """ Uses RequestFactory to construct Requests and returns an iterable of 
        Requests which will be sent to the LM.

        :param doc:
            The document as returned from training_docs, validation_docs, or test_docs.
        :param ctx: str
            The context string, generated by fewshot_context. This includes the natural 
            language description, as well as the few shot examples, and the question
            part of the document for `doc`. 
        """
        # TODO: implement evaluation.
        raise NotImplementedError('Evaluation not implemented')
    
    def process_results(self, doc, results):
        """Take a single document and the LM results and evaluates, returning a 
        dict where keys are the names of submetrics and values are the values of 
        the metric for that one document

        :param doc:
            The document as returned from training_docs, validation_docs, or test_docs.
        :param results:
            The results of the requests created in construct_requests.
        """
        # TODO: implement evaluation.
        raise NotImplementedError('Evaluation not implemented')

    def aggregation(self):
        """
        :returns: {str: [float] -> float}
            A dictionary where keys are the names of submetrics and values are 
            functions that aggregate a list of metrics
        """
        # TODO: implement evaluation.
        raise NotImplementedError('Evaluation not implemented')

    def higher_is_better(self):
        """
        :returns: {str: bool}
            A dictionary where keys are the names of submetrics and values are 
            whether a higher value of the submetric is better
        """
        # TODO: implement evaluation.
        raise NotImplementedError('Evaluation not implemented')